# SHT21 Arduino Library

## Description and details

Arduino library for interfacing [SHT21][breakout] temperature and humidity sensor over I2C to Arduino. Simple to use, it enables reading temperature and humidity from the chip. Additionally, it uses checksum to check if data arrived from SHT21 is correctly transmitted.

## Repository content

This repo contains Arduino library for SHT21 sensor. It also includes two examples:

- Demo example: reads temperature and humidity from SHT21 sensors and prints it to the Serial monitor
- Get Serial Number example: prints SHT21 hardcored Serial Number to Serial monitor

## Docs

- [SHT21 breakout board by e-radionica.com] [breakout]
- [SHT21 breakout by e-r.io] [hardware]

## How to use?

Install as any Arduino library. Go to File -> Examples -> eRadionica_SHT21 -> _choose your example_ and use!

You can use it for the Arduino IoT Cloud too, just go to Libraries -> Import -> _and upload the library in .zip format without extract_.

_Always up-to-date download of the library here: https://github.com/SolderedElectronics/SHT21-Arduino-Library/archive/refs/heads/master.zip_

## License info

This product is open-source. Yay!
For any tech questions, contact us at techsupport@e-radionica.com
If you find an Issue, please open one at GitHub. If you can improve our product, fork us.

e-r.io Team.

[breakout]: https://e-radionica.com/en/sht21-humidity-and-temperature-sensor.html
[hardware]: https://github.com/SolderedElectronics/SHT21-breakout-board-Eagle-files
