#include <avr/io.h>
#include <util/delay.h>
#include <Wire_low.h>
#include <Lcd1602_i2c_low.h>

#define RS           0
#define E            2
#define LED          3

byte led_b;

Lcd1602_i2c_low::Lcd1602_i2c_low(uint8_t addr_led){
    ADDR_LED = addr_led;
}

void Lcd1602_i2c_low::led(bool led_on_off){
    if(led_on_off==1){i2c_write_1bit(led_b |= (1<<LED));}
    if(led_on_off==0){i2c_write_1bit(led_b &=~ (1<<LED));}
}

void Lcd1602_i2c_low::Write(byte addr_w, byte wr1,byte wr2,byte wr3,byte wr4,byte wr5,byte wr6,byte wr7,byte wr8){
     lcd(0b01000000|addr_w*8);PrintChar(wr1);PrintChar(wr2);PrintChar(wr3);PrintChar(wr4);PrintChar(wr5);PrintChar(wr6);PrintChar(wr7);PrintChar(wr8);}

void Lcd1602_i2c_low::PrintInt(int data_int){char str[6];PrintString(itoa(data_int, str, 10));} 

void Lcd1602_i2c_low::PrintFloat(float data_float, byte dp){
    char str[8];
    if(data_float<0){data_float=-data_float;PrintChar(0b101101);PrintString(itoa((int)data_float, str, 10));}
     else{PrintString(itoa((int)data_float, str, 10));}
    int float10 = round((data_float - (int)data_float)*pow(10,dp));
    PrintChar(0b101110);
    PrintString(itoa(float10, str, 10));
} 

void Lcd1602_i2c_low::setInit(){ 
    lcd(0x03);_delay_us(4500);
    lcd(0x03);_delay_us(4500);
    lcd(0x03);_delay_us(200);
    lcd(0b00000010);_delay_ms(5);
    lcd(0b00001100);_delay_ms(5);
    lcd(0b00000001);
} 

void Lcd1602_i2c_low::Clear(){lcd(0b00000001);} 

void Lcd1602_i2c_low::Curs(byte str, byte mesto){
  if(str==0){lcd(0b10000000+mesto);}
  if(str==1){lcd(0b11000000+mesto);}
  } 

void Lcd1602_i2c_low::PrintString(const char* str) {while(*str != '\0') {_delay_us(200);PrintChar(*str);str++;}}

void Lcd1602_i2c_low::PrintChar(const char chr) {lcdSend(false, (uint8_t)chr);}

void Lcd1602_i2c_low::e_pin(){
    i2c_write_1bit(led_b |= (1<<E));
    _delay_us(200);
    i2c_write_1bit(led_b &= ~(1<<E));
}

void Lcd1602_i2c_low::lcd(uint8_t sett) {lcdSend(true, sett);}

void Lcd1602_i2c_low::lcdSend(bool rs, byte data) {
   // cli();
    if(rs==0){led_b |= (1<<RS);} else {led_b &= ~(1<<RS);}//RS
    _delay_us(200);
    if(((data >> 7) & 1) ==1){i2c_write_1bit(led_b |= (1<<7));} else {i2c_write_1bit(led_b &= ~(1<<7));}
    if(((data >> 6) & 1) ==1){i2c_write_1bit(led_b |= (1<<6));} else {i2c_write_1bit(led_b &= ~(1<<6));}
    if(((data >> 5) & 1) ==1){i2c_write_1bit(led_b |= (1<<5));} else {i2c_write_1bit(led_b &= ~(1<<5));}
    if(((data >> 4) & 1) ==1){i2c_write_1bit(led_b |= (1<<4));} else {i2c_write_1bit(led_b &= ~(1<<4));}
    e_pin();
    if(((data >> 3) & 1) ==1){i2c_write_1bit(led_b |= (1<<7));} else {i2c_write_1bit(led_b &= ~(1<<7));}
    if(((data >> 2) & 1) ==1){i2c_write_1bit(led_b |= (1<<6));} else {i2c_write_1bit(led_b &= ~(1<<6));}
    if(((data >> 1) & 1) ==1){i2c_write_1bit(led_b |= (1<<5));} else {i2c_write_1bit(led_b &= ~(1<<5));}
    if(((data >> 0) & 1) ==1){i2c_write_1bit(led_b |= (1<<4));} else {i2c_write_1bit(led_b &= ~(1<<4));}
    e_pin();
  //  sei();
}

void Lcd1602_i2c_low::i2c_write_1bit(byte i2c_reg){
  wire_start_w(ADDR_LED);
  wire_write(i2c_reg);
  wire_stop();
}  


