#define MENU_UP    0xB54A02FD
#define MENU_DOWN  0xB54A827D
#define UP         0xB54A50AF
#define DOWN       0xB54AD02F

#include <Wire.h>
#include <TDA7719.h>
#include <Wire.h>
#include <MsTimer2.h>
#include <LiquidCrystal.h>
#include <Encoder.h>
#include <EEPROM.h>
#include <boarddefs.h>
#include <IRremote.h>
    TDA7719 tda;
    IRrecv irrecv(13); // указываем вывод модуля IR приемника
    decode_results ir;
    Encoder myEnc(9, 8);//CLK, DT подключение энкодера
    LiquidCrystal lcd(7, 6, 2, 3, 4, 5);// RS,E,D4,D5,D6,D7 подключение LCD
   byte a1[8]={0b00000,0b10101,0b10101,0b10101,0b10101,0b10101,0b10101,0b00000};
   byte a2[8]={0b00000,0b10100,0b10100,0b10100,0b10100,0b10100,0b10100,0b00000};
   byte a3[8]={0b00000,0b10000,0b10000,0b10000,0b10000,0b10000,0b10000,0b00000};
   unsigned long newPosition,time,oldPosition  = -999;
   int menu,w,vol,vol_d,z,z0,z1,treb_f,mid_f,mid,mid_d,bass_f,bass,bass_d,treb,treb_d,loun,loun_d,loun_f,in,in0,menu2,faza,sub_f;
   int att_d,att_x,att,att_lf,att_rf,att_lr,att_rr,att_l,att_r,q,bass_q,mid_q,vol0,vol1,vol2,vol3,vol4,vol_att,vol_att_d;
   int g1,g2;
 
void setup(){ Serial.begin(9600);;irrecv.enableIRIn(); // запускаем модуль IR
   Wire.begin();lcd.begin(16, 2);lcd.createChar(0,a1);lcd.createChar(1,a2);lcd.createChar(2,a3);
   pinMode(A0,INPUT);// КНОПКА ЭНКОДЕРA
   pinMode(12,INPUT);// КНОПКА MENU2
   pinMode(11,INPUT);// КНОПКА SET
   pinMode(10,INPUT);// КНОПКА IN
   vol = EEPROM.read(0)-79;treb = EEPROM.read(1)-15;treb_f = EEPROM.read(2);mid = EEPROM.read(3)-15;mid_f = EEPROM.read(4);bass = EEPROM.read(5)-15;bass_f = EEPROM.read(6);
   loun = EEPROM.read(7)-15;loun_f = EEPROM.read(8);att_lf=EEPROM.read(9)-30;att_rf=EEPROM.read(10)-30;att_lr=EEPROM.read(11)-30;att_rr=EEPROM.read(12)-30;
   att_l=EEPROM.read(13)-30;att_r=EEPROM.read(14)-30;sub_f=EEPROM.read(15);faza=EEPROM.read(16);bass_q=EEPROM.read(17);mid_q=EEPROM.read(18);
   in0=EEPROM.read(19);vol0=EEPROM.read(20);vol1=EEPROM.read(21);vol2=EEPROM.read(22);vol3=EEPROM.read(23);vol4=EEPROM.read(24);inn();
   MsTimer2::set(3, to_Timer);MsTimer2::start();
   lcd.setCursor(0,0);lcd.print("    TDA7719    ");delay(1000);audio();
}
void to_Timer(){newPosition = myEnc.read()/4;}
 
void loop(){delay(10);
    if(analogRead(A0)<900&&menu2==0){menu++;cl();myEnc.write(0);time=millis();w=1;if(menu>4){menu=0;}}// меню
    if(digitalRead(12)==HIGH){menu2++;cl();menu=100;if(menu2>4){menu2=0;menu=0;}}
    if ( irrecv.decode( &ir )) {Serial.print("0x");Serial.println( ir.value,HEX);time=millis();w=1;irrecv.resume();}// IR приемник 
    
     if(ir.value==MENU_UP){menu++;g1=0;g2=0;cl();time=millis();w=1;if(menu>4){menu=0;}}// меню кнопка вверх
     if(ir.value==MENU_DOWN){menu--;g1=0;g2=0;cl();time=millis();w=1;if(menu<0){menu=4;}}// меню кнопка вниз
 //////////////////////////////////////// Громкость -79...0 дБ //////////////////////////////////////
 if(menu==0){
     if(ir.value==UP){vol++;g1=1;g2=0;cl1();time=millis();w=1;if(vol>0){vol=0;}if(vol<-79){vol=-79;}audio();}// кнопка +  
     if(ir.value==0xFFFFFFFF and g1==1){vol++;g2=0;cl1();time=millis();w=1;if(vol>0){vol=0;}if(vol<-79){vol=-79;}audio();}// кнопка >>>>>>
     if(ir.value==DOWN){vol--;g1=0;g2=1;cl1();time=millis();w=1;if(vol>0){vol=0;}if(vol<-79){vol=-79;}audio();}// кнопка -
     if(ir.value==0xFFFFFFFF and g2==1){vol--;g1=0;cl1();time=millis();w=1;if(vol>0){vol=0;}if(vol<-79){vol=-79;}audio();}// кнопка <<<<<<
   
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    vol=vol+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(vol>0){vol=0;}if(vol<-79){vol=-79;}audio();}
  lcd.setCursor(0,0);lcd.print("Volume  ");
  lcd.print(" ");lcd.print(vol);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");vol_d=vol+48;
   for(z=0,z0=0,z1=0;z<=vol_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1,1);lcd.print(" ");}}
   if(z1==3){lcd.setCursor(z0,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0,1);lcd.write((uint8_t)2);}}
///////////////////////////// Тембр ВЧ /////////////////////////////////////////////////////////////
  if(menu==1){
     if(ir.value==UP){treb++;g1=1;g2=0;cl1();time=millis();w=1;if(treb>15){treb=15;}if(treb<-15){treb=-15;}audio();}// кнопка +  
     if(ir.value==0xFFFFFFFF and g1==1){treb++;g2=0;cl1();time=millis();w=1;if(treb>15){treb=15;}if(treb<-15){treb=-15;}audio();}// кнопка >>>>>>
     if(ir.value==DOWN){treb--;g1=0;g2=1;cl1();time=millis();w=1;if(treb>15){treb=15;}if(treb<-15){treb=-15;}audio();}// кнопка -
     if(ir.value==0xFFFFFFFF and g2==1){treb--;g1=0;cl1();time=millis();w=1;if(treb>15){treb=15;}if(treb<-15){treb=-15;}audio();}// кнопка <<<<<<
    
     if((digitalRead(11)==HIGH)){cl();treb_f++;time=millis();w=1;if(treb_f>3){treb_f=0;}audio();}// f_center
     if (newPosition != oldPosition) {
    oldPosition = newPosition;
    treb=treb+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(treb>15){treb=15;}if(treb<-15){treb=-15;}audio();} 
  lcd.setCursor(0,0);lcd.print("Treble  ");
     switch(treb_f){case 0: lcd.print("10.0 kHz");break;case 1: lcd.print("12.5 kHz");break;case 2: lcd.print("15.0 kHz");break;case 3: lcd.print("17.5 kHz");break;}
  lcd.setCursor(10,1);lcd.print(" ");lcd.print(treb);lcd.print(" ");lcd.setCursor(14,1);lcd.print("dB");treb_d=treb+15;
   for(z=0,z0=0,z1=0;z<=treb_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1,1);lcd.print(" ");}}
   if(z1==3){lcd.setCursor(z0,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0,1);lcd.write((uint8_t)2);}}
///////////////////////////// Тембр СЧ /////////////////////////////////////////////////////////////
  if(menu==2){
     if(ir.value==UP){mid++;g1=1;g2=0;cl1();time=millis();w=1;if(mid>15){mid=15;}if(mid<-15){mid=-15;}audio();}// кнопка +  
     if(ir.value==0xFFFFFFFF and g1==1){mid++;g2=0;cl1();time=millis();w=1;if(mid>15){mid=15;}if(mid<-15){mid=-15;}audio();}// кнопка >>>>>>
     if(ir.value==DOWN){mid--;g1=0;g2=1;cl1();time=millis();w=1;if(mid>15){mid=15;}if(mid<-15){mid=-15;}audio();}// кнопка -
     if(ir.value==0xFFFFFFFF and g2==1){mid--;g1=0;cl1();time=millis();w=1;if(mid>15){mid=15;}if(mid<-15){mid=-15;}audio();}// кнопка <<<<<<
    
     if((digitalRead(11)==HIGH)){cl();mid_f++;time=millis();w=1;if(mid_f>3){mid_f=0;}audio();}// f_center
     if (newPosition != oldPosition) {
    oldPosition = newPosition;
    mid=mid+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(mid>15){mid=15;}if(mid<-15){mid=-15;}audio();} 
  lcd.setCursor(0,0);lcd.print("Middle  ");
     switch(mid_f){case 0: lcd.print(" 0.5 kHz");break;case 1: lcd.print(" 1.0 kHz");break;case 2: lcd.print(" 1.5 kHz");break;case 3: lcd.print(" 2.5 kHz");break;}
  lcd.setCursor(10,1);lcd.print(" ");lcd.print(mid);lcd.print(" ");lcd.setCursor(14,1);lcd.print("dB");mid_d=mid+15;
   for(z=0,z0=0,z1=0;z<=mid_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1,1);lcd.print(" ");}}
   if(z1==3){lcd.setCursor(z0,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0,1);lcd.write((uint8_t)2);}}
///////////////////////////// Тембр НЧ /////////////////////////////////////////////////////////////
  if(menu==3){
     if(ir.value==UP){bass++;g1=1;g2=0;cl1();time=millis();w=1;if(bass>15){bass=15;}if(bass<-15){bass=-15;}audio();}// кнопка +  
     if(ir.value==0xFFFFFFFF and g1==1){bass++;g2=0;cl1();time=millis();w=1;if(bass>15){bass=15;}if(bass<-15){bass=-15;}audio();}// кнопка >>>>>>
     if(ir.value==DOWN){bass--;g1=0;g2=1;cl1();time=millis();w=1;if(bass>15){bass=15;}if(bass<-15){bass=-15;}audio();}// кнопка -
     if(ir.value==0xFFFFFFFF and g2==1){bass--;g1=0;cl1();time=millis();w=1;if(bass>15){bass=15;}if(bass<-15){bass=-15;}audio();}// кнопка <<<<<<
    
     if((digitalRead(11)==HIGH)){cl();bass_f++;time=millis();w=1;if(bass_f>3){bass_f=0;}audio();}// f_center
     if (newPosition != oldPosition) {
    oldPosition = newPosition;
    bass=bass+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(bass>15){bass=15;}if(bass<-15){bass=-15;}audio();} 
  lcd.setCursor(0,0);lcd.print("Bass    ");
     switch(bass_f){case 0: lcd.print("  60  Hz");break;case 1: lcd.print("  80  Hz");break;case 2: lcd.print(" 100  Hz");break;case 3: lcd.print(" 200  Hz");break;}
  lcd.setCursor(10,1);lcd.print(" ");lcd.print(bass);lcd.print(" ");lcd.setCursor(14,1);lcd.print("dB");bass_d=bass+15;
   for(z=0,z0=0,z1=0;z<=bass_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1,1);lcd.print(" ");}}
   if(z1==3){lcd.setCursor(z0,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0,1);lcd.write((uint8_t)2);}}
///////////////////////////// Loudness /////////////////////////////////////////////////////////////
  if(menu==4){
     if(ir.value==UP){loun++;g1=1;g2=0;cl1();time=millis();w=1;if(loun>0){loun=0;}if(loun<-15){loun=-15;}audio();}// кнопка +  
     if(ir.value==0xFFFFFFFF and g1==1){loun++;g2=0;cl1();time=millis();w=1;if(loun>0){loun=0;}if(loun<-15){loun=-15;}audio();}// кнопка >>>>>>
     if(ir.value==DOWN){loun--;g1=0;g2=1;cl1();time=millis();w=1;if(loun>0){loun=0;}if(loun<-15){loun=-15;}audio();}// кнопка -
     if(ir.value==0xFFFFFFFF and g2==1){loun--;g1=0;cl1();time=millis();w=1;if(loun>0){loun=0;}if(loun<-15){loun=-15;}audio();}// кнопка <<<<<<
    
     if((digitalRead(11)==HIGH)){cl();loun_f++;time=millis();w=1;if(loun_f>3){loun_f=0;}audio();}// f_center
     if (newPosition != oldPosition) {
    oldPosition = newPosition;
    loun=loun+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(loun>0){loun=0;}if(loun<-15){loun=-15;}audio();} 
  lcd.setCursor(0,0);lcd.print("Loudness");
     switch(loun_f){case 0: lcd.print("  FLAT  ");break;case 1: lcd.print(" 400  Hz");break;case 2: lcd.print(" 800  Hz");break;case 3: lcd.print(" 2.4 kHz");break;}
  lcd.setCursor(10,1);lcd.print(" ");lcd.print(loun);lcd.print(" ");lcd.setCursor(14,1);lcd.print("dB");loun_d=loun*2+30;
   for(z=0,z0=0,z1=0;z<=loun_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1,1);lcd.print(" ");}}
   if(z1==3){lcd.setCursor(z0,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0,1);lcd.write((uint8_t)2);}}
/////////////// ATT OUT ///////////////////////////////////////////////////////////////// 
if(menu2==1){
    if((digitalRead(11)==HIGH)){cl();att_x++;if(att_x>5){att_x=0;}}// att out
      lcd.setCursor(13,1);
       switch(att_x){case 0: lcd.print("LF");att = att_lf;break;case 1: lcd.print("RF");att = att_rf;break;case 2: lcd.print("LR");att = att_lr;break;
          case 3: lcd.print("RR");att = att_rr;break;case 4: lcd.print("SL");att = att_l;break;case 5: lcd.print("SR");att = att_r;break;}
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    att=att+newPosition;myEnc.write(0);newPosition=0;if(att>0){att=0;}if(att<-30){att=-30;}audio();}
     lcd.setCursor(0,0);lcd.print("Attenuation OUT");
       switch(att_x){case 0: att_lf = att;break;case 1: att_rf = att;break;case 2: att_lr = att;break;
          case 3: att_rr = att;break;case 4: att_l =  att;break;case 5: att_r =  att;break;} 
  lcd.setCursor(6,1);lcd.print(" ");lcd.print(att);lcd.print(" ");lcd.setCursor(10,1);lcd.print("dB");att_d=att/2+15;
   for(z=0,z0=0,z1=0;z<=att_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1,1);lcd.print(" ");}}
   if(z1==3){lcd.setCursor(z0,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0,1);lcd.write((uint8_t)2);}}
///////////////////////////// sub /////////////////////////////////////////////////////
   if(menu2==2){
       lcd.setCursor(0,0);lcd.print("Subwoofer");
      if((digitalRead(11)==HIGH)){cl();sub_f++;if(sub_f>3){sub_f=0;}}
       lcd.setCursor(0,1);lcd.print("F: ");lcd.setCursor(3,1);
       switch(sub_f){case 0: lcd.print("FLAT  ");break;case 1: lcd.print("80 Hz ");break;
       case 2: lcd.print("120 Hz");break;case 3: lcd.print("160 Hz");break;}
     if(analogRead(A0)<900){faza++;cl();if(faza>1){faza=0;}audio();}
    lcd.setCursor(10,1);
    switch(faza){case 0: lcd.print("Ph 180 ");break;case 1: lcd.print("Ph   0 ");break;}}
/////////////////////////// q factor //////////////////////////////////////////////////
  if(menu2==3){
      lcd.setCursor(0,0);lcd.print("Q Factor");
     if((digitalRead(11)==HIGH)){cl();q++;if(q>1){q=0;}}
     lcd.setCursor(0,1);
     switch(q){case 0: lcd.print("Bass  ");break;case 1: lcd.print("Middle");break;}
     if(q==0){if(analogRead(A0)<900){bass_q++;cl();if(bass_q>3){bass_q=0;}audio();}
      switch(bass_q){case 0: lcd.print("  1.0 ");break;case 1: lcd.print("  1.25");break;case 2: lcd.print("  1.5 ");break;case 3: lcd.print("  2.0 ");break;}}
     if(q==1){if(analogRead(A0)<900){mid_q++;cl();if(mid_q>3){mid_q=0;}audio();}
      switch(mid_q){case 0: lcd.print("  0.5 ");break;case 1: lcd.print("  0.75");break;case 2: lcd.print("  1.0 ");break;case 3: lcd.print("  1.25 ");break;}}    }
//////////////////////// in //////////////////////////////////////////////////////////
 inn();    if((digitalRead(10)==HIGH)){cl();in0++;if(in0>5){in0=0;}lcd.setCursor(0,0);lcd.print("INPUT ");lcd.print(in0);inn();audio();delay(1000);cl();  }
//////////////////////////////////// att input ////////////////////////////////////////////
  if(menu2==4){ 
        switch(in){
     case 0: vol_att = vol0;break;
     case 1: vol_att = vol1;break;
     case 2: vol_att = vol2;break;
     case 5: vol_att = vol3;break;
     case 6: vol_att = vol4;break;
     }
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    vol_att=vol_att+newPosition;myEnc.write(0);newPosition=0;if(vol_att<-15){vol_att=-15;}if(vol_att>15){vol_att=15;}audio();}  
       switch(in){
     case 0: vol0 = vol_att;break;
     case 1: vol1 = vol_att;break;
     case 2: vol2 = vol_att;break;
     case 5: vol3 = vol_att;break;
     case 6: vol4 = vol_att;break;
     }
      lcd.setCursor(0,0);lcd.print("Attenuator IN ");lcd.print(in0);
      lcd.setCursor(10,1);lcd.print(" ");lcd.print(vol_att);lcd.print(" ");lcd.setCursor(14,1);lcd.print("dB");vol_att_d=vol_att+15;
   for(z=0,z0=0,z1=0;z<=vol_att_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1,1);lcd.print(" ");}}
   if(z1==3){lcd.setCursor(z0,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0,1);lcd.write((uint8_t)2);}
  }
///////////////////// EEPROM /////////////////////////////////////////////
 if(millis()-time>10000 && w==1 && menu2==0){ inn();
     EEPROM.update(0,vol+79);EEPROM.update(1,treb+15);EEPROM.update(2,treb_f);EEPROM.update(3,mid+15);EEPROM.update(4,mid_f);EEPROM.update(5,bass+15);EEPROM.update(6,bass_f);
     EEPROM.update(7,loun+15);EEPROM.update(8,loun_f);EEPROM.update(9,att_lf+30);EEPROM.update(10,att_rf+30);EEPROM.update(11,att_lr+30);EEPROM.update(12,att_rr+30);
     EEPROM.update(13,att_l+30);EEPROM.update(14,att_r+30);EEPROM.update(15,sub_f);EEPROM.update(16,faza);EEPROM.update(17,bass_q);EEPROM.update(18,mid_q);
     EEPROM.update(18,mid_q);EEPROM.update(19,in0);EEPROM.update(20,vol0);EEPROM.update(21,vol1);EEPROM.update(22,vol2);EEPROM.update(23,vol3);EEPROM.update(24,vol4);
     cl();menu=0;w=0;}
 
}
void inn(){if(in0==3){in=6;}else{in=in0;}}
void cl(){ir.value=0;delay(300);lcd.clear();}
void cl1(){ir.value=0;delay(50);}
void audio(){
tda.setInput(in,1,1,2); // 0...7, 0...1, 0...1, 0...7
tda.setInput_2(0,0,1,1,1,1); // 0...7, 0...1, 0...1, 0...1, 0...1, 0...1 
tda.setMix_source(7,0); // 0...7, 0...-31
tda.setMix_cont(1,1,1,1,1,1,1,1); // all 0...1
tda.setMute(1,0,0,1,1,1,1); // 0...1, 0...1, 0...3, 0...1, 0...1, 0...1, 0...1
tda.setSoft_1(1,1,1,1,1,1,1,1); //all 0...1
tda.setSoft_2(1,1,1,1,0,3); // 0...1, 0...1, 0...1, 0...1, 0...2, 0...3
tda.setLoudness(loun,loun_f,1,1); // 0...-15, 0...3, 0...1, 0...1 
tda.setVol(vol_att,1,1); // -15...+15, 0...1, 0...1
tda.setTreble(treb,treb_f,1); // -15...+15, 0...3, 0...1
tda.setMiddle(mid,mid_q,1); // -15...+15, 0...3, 0...1
tda.setBass(bass,bass_q,1); // -15...+15, 0...3, 0...1
tda.setSMB(sub_f,faza,mid_f,bass_f,1); // 0...3, 0...1, 0...3, 0...3, 0...1
tda.setVol_LF(vol+att_lf,1); // 0...-79, 0...1
tda.setVol_RF(vol+att_rf,1); // 0...-79, 0...1
tda.setVol_LR(vol+att_lr,1); // 0...-79, 0...1
tda.setVol_RR(vol+att_rr,1); // 0...-79, 0...1
tda.setVol_SUB_L(vol+att_l,1); // 0...-79, 0...1
tda.setVol_SUB_R(vol+att_r,1); // 0...-79, 0...1
tda.setTest1(0,14,1,1); // 0...1, 0...15, 0...1, 0...1
tda.setTest2(0,1,1,3); // 0...1, 0...1, 0...1, 0...3
}
