#include <Wire.h>
#include <EEPROM.h>
#include <MsTimer2.h> // https://rcl-radio.ru/wp-content/uploads/2018/11/MsTimer2.zip
#include <Encoder.h>  // https://rcl-radio.ru/wp-content/uploads/2019/05/Encoder.zip
#include <LiquidCrystal_I2C.h> //Библиотека -  http://forum.rcl-radio.ru/misc.php?action=pan_download&item=45&download=1
 LiquidCrystal_I2C lcd(0x27,16,2);  // Устанавливаем дисплей 
 Encoder myEnc(9, 8);//CLK, DT
      byte v1[8] = {7,7,7,7,7,7,7,7};
      byte v2[8] = {7,7,0, 0, 0, 0, 0, 0};      
      byte v3[8] = { 0, 0, 0, 0, 0,0,31,31};
      byte v4[8] = {31,31, 0, 0, 0, 0,31,31};
      byte v5[8] = { 28, 28, 0, 0, 0, 0, 28, 28};//
      byte v6[8] = {28,28,28,28,28,28,28,28};
      byte v7[8] = { 0, 0, 0, 0, 0, 0,7,7};
      byte v8[8] = { 31, 31,0,0,0,0,0, 0};
      int a[3];
      byte i,d1,d2,d3,d4,d5,d6,e1,e2,e3;
 unsigned long time,oldPosition  = -999,newPosition;
 int vol,vol_d,in,balanc,balanc_d,menu;
 bool w,mute;

void setup() {
 Wire.begin();
 lcd.init();lcd.backlight();
 pinMode(10,INPUT);   // кнопка энкодера
 pinMode(A0,OUTPUT);  // RSEL1
 pinMode(A1,OUTPUT);  // RSEL0
 pinMode(2,INPUT_PULLUP); // кнопка IN
 pinMode(3,INPUT_PULLUP); // кнопка MUTE
 lcd.createChar(1, v1);lcd.createChar(2, v2);lcd.createChar(3, v3);
 lcd.createChar(4, v4);lcd.createChar(5, v5);lcd.createChar(6, v6);
 lcd.createChar(7, v7);lcd.createChar(8, v8);
 Serial.begin(9600);
 lcd.setCursor(0,0);lcd.print("     CS4398     ");
 lcd.setCursor(0,1);lcd.print("     CS8416     ");
 MsTimer2::set(1, to_Timer);MsTimer2::start();
 delay(1000);
 vol = EEPROM.read(0);in = EEPROM.read(1);balanc = EEPROM.read(2);
 wireWrite(0x4C, 0x02, 0b00011010);// I2S 24 bit / 48 kHz / 100...200 kHz
 wireWrite(0x4C, 0x03, 0b00001001);// default
 wireWrite(0x4C, 0x04, 0b11100000);// default
 wireWrite(0x4C, 0x05, vol+balanc+20);
 wireWrite(0x4C, 0x06, vol-balanc+20);
 wireWrite(0x4C, 0x07, 0b10110000);// default
 wireWrite(0x4C, 0x08, 0b01000000);// default
 wireWrite(0x4C, 0x09, 0b00001000);// default
 Serial.print("Chip ID 0");
 Serial.println(wireRead(0x4C, 0x01),BIN);
 lcd.clear();
 switch(in){
 case 0: digitalWrite(A0, LOW);digitalWrite(A1, LOW);lcd.print("COAX 1");break;// px0 
 case 1: digitalWrite(A0, LOW);digitalWrite(A1, HIGH);lcd.print("COAX 2");break;// px1
 case 2: digitalWrite(A0, HIGH);digitalWrite(A1, LOW);lcd.print("COAX 3");break;// px2
 }
}

void loop() {
 /// MENU /////////////////////////////////////// 
 if(digitalRead(10)==LOW){menu++;if(menu>1){menu=0;}lcd.clear();time=millis();w=1;delay(200);}
  
 /// INPUT ////////////////////////////////////// 
 if(digitalRead(2)==LOW){in++;if(in>2){in=0;}lcd.clear();time=millis();w=1;
 lcd.setCursor(5,0);lcd.print("INPUT");lcd.setCursor(5,1);
 switch(in){
 case 0: digitalWrite(A0, LOW);digitalWrite(A1, LOW);lcd.print("COAX 1");break;// px0 
 case 1: digitalWrite(A0, LOW);digitalWrite(A1, HIGH);lcd.print("COAX 2");break;// px1
 case 2: digitalWrite(A0, HIGH);digitalWrite(A1, LOW);lcd.print("COAX 3");break;// px2
 }delay(1000);lcd.clear();}
 
 /// MUTE /////////////////////////////
 if(digitalRead(3)==LOW && mute==0){mute=1;wireWrite(0x4C, 0x04, 0b11011000);delay(300);} 
 if(digitalRead(3)==LOW && mute==1){mute=0;wireWrite(0x4C, 0x04, 0b11000000);delay(300);} 
 if(mute==1){lcd.setCursor(0,1);lcd.print("MUTE  ");}
 else{lcd.setCursor(0,1);lcd.print("COAX ");lcd.print(in+1);
 }
 
 /// VOLUME + BALANCE ////////////////
 if(menu==0){
 if (newPosition != oldPosition){oldPosition = newPosition;
     vol=vol+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;
      if(vol<0){vol=0;}if(vol>150){vol=150;}
      wireWrite(0x4C, 0x05, vol+balanc+20);
      wireWrite(0x4C, 0x06, vol-balanc+20);}
      lcd.setCursor(0,0);lcd.print("VOLUME ");
     vol_d=150-vol;
     a[0]=vol_d/100;
     a[1]=vol_d/10%10;
     a[2]=vol_d%10;

 }

 if(menu==1){
 if (newPosition != oldPosition){oldPosition = newPosition;
     balanc=balanc+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;
      if(balanc<-20){balanc=-20;}if(balanc>20){balanc=20;}
      wireWrite(0x4C, 0x05, vol+balanc+20);
      wireWrite(0x4C, 0x06, vol-balanc+20);}
      lcd.setCursor(0,0);lcd.print("BALANCE ");
     if(balanc<0){lcd.setCursor(9,0);lcd.write((uint8_t)3);}else{lcd.setCursor(9,0);lcd.print(" ");}
     balanc_d=abs(balanc);
     a[0]=balanc_d/10;
     a[1]=balanc_d%10;
 }
  //////////////////////////////////  
    if(menu==0){
      for(i=0;i<3;i++){
      switch(i){
        case 0: e1=7,e2=8,e3=9;break;
        case 1: e1=10,e2=11,e3=12;break;
        case 2: e1=13,e2=14,e3=15;break;
        }
      switch(a[i]){
        case 0: d1=1,d2=8,d3=6,d4=1,d5=3,d6=6;break;
        case 1: d1=32,d2=2,d3=6,d4=32,d5=32,d6=6;break;
        case 2: d1=2,d2=8,d3=6,d4=1,d5=4,d6=5;break;
        case 3: d1=2,d2=4,d3=6,d4=7,d5=3,d6=6;break;
        case 4: d1=1,d2=3,d3=6,d4=32,d5=32,d6=6;break;
        case 5: d1=1,d2=4,d3=5,d4=7,d5=3,d6=6;break;
        case 6: d1=1,d2=4,d3=5,d4=1,d5=3,d6=6;break;
        case 7: d1=1,d2=8,d3=6,d4=32,d5=32,d6=6;break;
        case 8: d1=1,d2=4,d3=6,d4=1,d5=3,d6=6;break;
        case 9: d1=1,d2=4,d3=6,d4=7,d5=3,d6=6;break;
    }
     
      lcd.setCursor(e1,0);lcd.write((uint8_t)d1);lcd.setCursor(e2,0);lcd.write((uint8_t)d2);lcd.setCursor(e3,0);lcd.write((uint8_t)d3);
      lcd.setCursor(e1,1);lcd.write((uint8_t)d4);lcd.setCursor(e2,1);lcd.write((uint8_t)d5);lcd.setCursor(e3,1);lcd.write((uint8_t)d6);
 }}
///////////////////////////////////////
if(menu==1){
       for(i=0;i<2;i++){
      switch(i){
        case 0: e1=10,e2=11,e3=12;break;
        case 1: e1=13,e2=14,e3=15;break;
        }
      switch(a[i]){
        case 0: d1=1,d2=8,d3=6,d4=1,d5=3,d6=6;break;
        case 1: d1=32,d2=2,d3=6,d4=32,d5=32,d6=6;break;
        case 2: d1=2,d2=8,d3=6,d4=1,d5=4,d6=5;break;
        case 3: d1=2,d2=4,d3=6,d4=7,d5=3,d6=6;break;
        case 4: d1=1,d2=3,d3=6,d4=32,d5=32,d6=6;break;
        case 5: d1=1,d2=4,d3=5,d4=7,d5=3,d6=6;break;
        case 6: d1=1,d2=4,d3=5,d4=1,d5=3,d6=6;break;
        case 7: d1=1,d2=8,d3=6,d4=32,d5=32,d6=6;break;
        case 8: d1=1,d2=4,d3=6,d4=1,d5=3,d6=6;break;
        case 9: d1=1,d2=4,d3=6,d4=7,d5=3,d6=6;break;
    }
     
      lcd.setCursor(e1,0);lcd.write((uint8_t)d1);lcd.setCursor(e2,0);lcd.write((uint8_t)d2);lcd.setCursor(e3,0);lcd.write((uint8_t)d3);
      lcd.setCursor(e1,1);lcd.write((uint8_t)d4);lcd.setCursor(e2,1);lcd.write((uint8_t)d5);lcd.setCursor(e3,1);lcd.write((uint8_t)d6);
 }}


 delay(20);if(millis()-time>10000 && w==1){w=0;EEPROM.write(0,vol);EEPROM.write(1,in);EEPROM.write(2,balanc+20);
 menu=0;}
 }// loop
 
void wireWrite(byte addr, byte reg, byte data){
  Wire.beginTransmission(addr);
  Wire.write (reg);
  Wire.write (data);
  Wire.endTransmission();
  }

byte wireRead(int addr, int reg){
  Wire.beginTransmission(addr);
  Wire.write (reg);
  Wire.endTransmission();
  Wire.requestFrom(addr,1);
  while(Wire.available()<1);
  byte value = Wire.read();
  return value;
  }  

void to_Timer(){newPosition = myEnc.read()/4;}  
