#include <LED4x7.h>

      int data_;
      byte x_dp,x_seg;
      char mass[4];
      bool pd;
      byte br;
      char h0_,h1_,h2_,h3_;

void led_timer(){
  DDRD = 0B11111111;
  DDRB = 0B00001111;
  cli();
  TCCR2A = 0;TCCR2B = 0;OCR2A = 50;
  TCCR2B |= (1 << CS22)|(1 << CS20)|(1 << WGM22);
  TIMSK2 |= (1 << OCIE2A);
  sei();
  } 

void led_setInt(int data, byte pp, byte brig , char h0, char h1, char h2, char h3){
  data_ = data;
  x_dp = pp;
  br = brig;
  h0_=h0;h1_=h1;h2_=h2;h3_=h3;
  } 


void seg(){
  switch(mass[x_seg]){   // ABCDEFGP             
          case 0: PORTD = 0b11111100|pd;break; // 0
          case 1: PORTD = 0b01100000|pd;break; // 1
          case 2: PORTD = 0b11011010|pd;break; // 2
          case 3: PORTD = 0b11110010|pd;break; // 3
          case 4: PORTD = 0b01100110|pd;break; // 4
          case 5: PORTD = 0b10110110|pd;break; // 5
          case 6: PORTD = 0b10111110|pd;break; // 6
          case 7: PORTD = 0b11100000|pd;break; // 7
          case 8: PORTD = 0b11111110|pd;break; // 8
          case 9: PORTD = 0b11110110|pd;break; // 9
          case 10:PORTD = 0b00000000|pd;break; // пусто
          case 11:PORTD = 0b11101110|pd;break; // A
          case 12:PORTD = 0b00111110|pd;break; // b
          case 13:PORTD = 0b10011100|pd;break; // C
          case 14:PORTD = 0b00011010|pd;break; // c
          case 15:PORTD = 0b01111010|pd;break; // d
          case 16:PORTD = 0b10011110|pd;break; // E
          case 17:PORTD = 0b10001110|pd;break; // F
          case 18:PORTD = 0b11001110|pd;break; // P
          case 19:PORTD = 0b00111000|pd;break; // u
          case 20:PORTD = 0b01111100|pd;break; // U
          case 21:PORTD = 0b00000010|pd;break; // -
          case 22:PORTD = 0b00010010|pd;break; // нижнее = 
          case 23:PORTD = 0b10000010|pd;break; // верхнее = 
          case 24:PORTD = 0b00001010|pd;break; // r
          case 25:PORTD = 0b00111010|pd;break; // нижнее o
          case 26:PORTD = 0b11000110|pd;break; // верхнее o
          case 27:PORTD = 0b00011110|pd;break; // t
}}

 /* AAAAA
   F     B
   F     B
    GGGGG
   E     C
   E     C
    DDDDD */

void  cif(){
  if(h0_<10){mass[0]=data_/1000;}else{mass[0]=h0_;}
  if(h1_<10){mass[1]=data_/100%10;}else{mass[1]=h1_;}
  if(h2_<10){mass[2]=data_/10%10;}else{mass[2]=h2_;}
  if(h3_<10){mass[3]=data_%10;}else{mass[3]=h3_;}
  
  if(x_seg+1==x_dp&&x_dp>0){pd=1;}else{pd=0;}
  switch(x_seg){
  case 0: mass[0];PORTB = 0x01;delayMicroseconds(br*100);PORTB = 0x00;pd;seg();break;
  case 3: mass[1];PORTB = 0x02;delayMicroseconds(br*100);PORTB = 0x00;pd;seg();break;
  case 2: mass[2];PORTB = 0x04;delayMicroseconds(br*100);PORTB = 0x00;pd;seg();break;
  case 1: mass[3];PORTB = 0x08;delayMicroseconds(br*100);PORTB = 0x00;pd;seg();break;
  }
  
  x_seg++;
  if(x_seg>3){x_seg=0;}
  }

ISR(TIMER2_COMPA_vect){cif();}
