SparkFun Si4703 Arduino Library
========================================

<table class="table table-hover table-striped table-bordered">
  <tr align="center">
   <td><a href="https://www.sparkfun.com/products/11083"><img src="https://cdn.sparkfun.com/r/600-600/assets/parts/6/2/3/5/11083-02.jpg" alt="SparkFun Si4703"></a></td>
   <td><a href="https://www.sparkfun.com/products/12938"><img src="https://cdn.sparkfun.com/r/600-600/assets/parts/9/8/6/6/12938-01.jpg" alt="SparkFun FM Tuner Evaluation Board - Si4703"></a></td>
  </tr>
  <tr align="center">
    <td><i>SparkFun Si4703 Breakout [<a href="https://www.sparkfun.com/products/11083">BOB-11083</a>]</i></td>
    <td><i>SparkFun FM Tuner Evaluation Board - Si4703 [<a href="https://www.sparkfun.com/products/12938">WRL-12938</a>]</i></td>
  </tr>
</table>


Basic functionality of the Si4703 FM tuner chip. Allows user to tune to different FM stations, find station ID and song name, and RDS and RBDS information.

Repository Contents
-------------------

* **/examples** - Example sketches for the library (.ino). Run these from the Arduino IDE. 
* **/src** - Source files for the library (.cpp, .h).
* **keywords.txt** - Keywords from this library that will be highlighted in the Arduino IDE. 
* **library.properties** - General library properties for the Arduino package manager. 

Documentation
--------------

* **[Installing an Arduino Library Guide](https://learn.sparkfun.com/tutorials/installing-an-arduino-library)** - Basic information on how to install an Arduino library.
* **[Hookup Guide](https://learn.sparkfun.com/tutorials/si4703-fm-radio-receiver-hookup-guide)** - Basic hookup Guide for the SI4703 Evaluation board.
* **[Product Repository](https://github.com/sparkfun/FM_Tuner_Basic_Breakout-Si4703)** - Main repository (including hardware files) for the Si4703 Breakout.

Products that use this Library 
---------------------------------
* [SparkFun FM Tuner Evaluation Board](https://www.sparkfun.com/products/10663)- Evaluation board for Si4703. Includes audio jack. 
* [SparkFun FM Tuner Basic Breakout](https://www.sparkfun.com/products/11083)- Basic breakout of Si4703.

License Information
-------------------

This product is _**open source**_! 

Distributed as-is; no warranty is given.

- Your friends at SparkFun.

_The original SparkFun code was modified by Simon Monk. Thanks Simon!_
