// Библиотека основана на - https://github.com/enjoyneering/STM32_Encoder

#ifndef STM32_Encoder_h
#define STM32_Encoder_h

#include <Arduino.h>


class STM32_Encoder
{
  public:
    STM32_Encoder(uint8_t encoderA, uint8_t encoderB);

    void     begin(void);
    void     readAB(void);
    int16_t  getPosition(void);
    void     setPosition(int16_t position); 


  private:
             uint8_t pinA;           //pin "A"
             uint8_t pinB;           //pin "B"

    volatile uint8_t _prevValueAB = 0;    //previouse state of "A"+"B"
    volatile uint8_t _currValueAB = 0;    //current   state of "A"+"B"
   
  protected:
    volatile int16_t _counter     = 0;    //encoder click counter, limits -32768..32767
      
};

#endif
