#include "STM32_Encoder.h"

STM32_Encoder::STM32_Encoder(uint8_t encoderA, uint8_t encoderB){
  pinA      = encoderA;
  pinB      = encoderB;
}

void STM32_Encoder::begin(){
  pinMode(pinA,INPUT); 
  pinMode(pinB,INPUT);
}


void STM32_Encoder::readAB(){
   noInterrupts();                                       

  _currValueAB  = digitalRead(pinA) << 1;
  _currValueAB |= digitalRead(pinB);

  switch ((_prevValueAB | _currValueAB)){
    case 0b0001:                                       
      _counter++;
      break;
    case 0b0100:                                        
      _counter--;
      break;
  }
  _prevValueAB = _currValueAB << 2;                     
  interrupts();                
}

int16_t STM32_Encoder::getPosition(){
  return _counter;
}

void STM32_Encoder::setPosition(int16_t position){
  _counter = position;
}


