package com.androidsmile.labb01;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import app.akexorcist.bluetotohspp.library.BluetoothSPP;
import app.akexorcist.bluetotohspp.library.BluetoothState;
import app.akexorcist.bluetotohspp.library.DeviceList;


public class MainActivity extends AppCompatActivity {

   int hug;
   int kol;



   String[] arr;


    BluetoothSPP bluetooth;
    TextView txtArduino;
    TextView textView9;
    TextView textView;
    TextView textView3;
    TextView textView4;
    TextView textView5;
    TextView textView6;
    TextView textView7;
    Button connect;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        bluetooth = new BluetoothSPP(this);
        connect = (Button) findViewById(R.id.connect);
        txtArduino = (TextView) findViewById(R.id.txtArduino);

        textView9 = (TextView) findViewById(R.id.textView9);
        textView = (TextView) findViewById(R.id.textView);
        textView3 = (TextView) findViewById(R.id.textView3);
        textView4 = (TextView) findViewById(R.id.textView4);
        textView5 = (TextView) findViewById(R.id.textView5);
        textView6 = (TextView) findViewById(R.id.textView6);
        textView7 = (TextView) findViewById(R.id.textView7);

        if (!bluetooth.isBluetoothAvailable()) {
            Toast.makeText(getApplicationContext(), "Bluetooth не доступен", Toast.LENGTH_SHORT).show();
            finish();
        }

        bluetooth.setBluetoothConnectionListener(new BluetoothSPP.BluetoothConnectionListener() {
            public void onDeviceConnected(String name, String address) {
                connect.setText("Подключен " + name);
            }

            public void onDeviceDisconnected() {
                connect.setText("Связь потеряна");
            }

            public void onDeviceConnectionFailed() {
                connect.setText("Не удается подключиться");
            }
        });

        connect.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (bluetooth.getServiceState() == BluetoothState.STATE_CONNECTED) {
                    bluetooth.disconnect();
                } else {
                    Intent intent = new Intent(getApplicationContext(), DeviceList.class);
                    startActivityForResult(intent, BluetoothState.REQUEST_CONNECT_DEVICE);
                }
            }
        });

////////////////////////// прием данных с порта ................!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        bluetooth.setOnDataReceivedListener(new BluetoothSPP.OnDataReceivedListener() {
            public void onDataReceived(byte[] data, String message) {
              //  Toast.makeText(getApplicationContext(), String.format("Data Received: %s", message),
                 //       Toast.LENGTH_SHORT).show();
                kol = message.length();// длина string
                if(kol>4) {
                    arr = message.split(":");// разбивка string
                    hug = Integer.parseInt(arr[1].trim());// string to int

                    txtArduino.setText(arr[0] + "\u00B0C");
                    textView.setText(arr[3] + "\u00B0C");
                    textView5.setText(arr[2] + " мм.рт.ст");
                    textView7.setText(hug + " %");
                }
            } });




    }/// onCreate

    public void onStart() {
        super.onStart();
        if (!bluetooth.isBluetoothEnabled()) {
            bluetooth.enable();
        } else {
            if (!bluetooth.isServiceAvailable()) {
                bluetooth.setupService();
                bluetooth.startService(BluetoothState.DEVICE_OTHER);
            }
        }
    }


    public void onDestroy() {
        super.onDestroy();
        bluetooth.stopService();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == BluetoothState.REQUEST_CONNECT_DEVICE) {
            if (resultCode == Activity.RESULT_OK)
                bluetooth.connect(data);
        } else if (requestCode == BluetoothState.REQUEST_ENABLE_BT) {
            if (resultCode == Activity.RESULT_OK) {
                bluetooth.setupService();
            } else {
                Toast.makeText(getApplicationContext()
                        , "Bluetooth не был включен"
                        , Toast.LENGTH_SHORT).show();
                finish();
            }
        }
    }

}

