/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketException;
import processing.app.debug.MessageConsumer;

public class MessageSiphon
implements Runnable {
    private final BufferedReader streamReader;
    private final MessageConsumer consumer;
    private Thread thread;
    private boolean canRun;

    public MessageSiphon(InputStream stream, MessageConsumer consumer) {
        this.streamReader = new BufferedReader(new InputStreamReader(stream));
        this.consumer = consumer;
        this.canRun = true;
        this.thread = new Thread(this);
        this.thread.setPriority(9);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String currentLine;
            while (this.canRun && (currentLine = this.streamReader.readLine()) != null) {
                this.consumer.message(currentLine + "\n");
            }
        }
        catch (NullPointerException npe) {
        }
        catch (SocketException e) {
        }
        catch (Exception e) {
            String mess = e.getMessage();
            if (mess != null && mess.indexOf("Bad file descriptor") != -1) {
            } else {
                e.printStackTrace();
            }
        }
        finally {
            this.thread = null;
        }
    }

    public void join() throws InterruptedException {
        Thread t = this.thread;
        if (t != null) {
            t.join();
        }
    }

    public void stop() {
        this.canRun = false;
    }
}

