#include <Wire.h>

#include <PT2322.h>
#include <LiquidCrystal.h>
#include <EEPROM.h>

 PT2322 pt1;
 LiquidCrystal lcd(7, 6, 2, 3, 4, 5);// RS,E,D4,D5,D6,D7 подключение LCD
   byte a1[8]={0b00000,0b11011,0b11011,0b11011,0b11011,0b11011,0b11011,0b00000};
   byte a2[8]={0b00000,0b11000,0b11000,0b11000,0b11000,0b11000,0b11000,0b00000};
   unsigned long time;
   int menu,w,vol,vol_d,z,in,bass,bass_d,mid,mid_d,treb,treb_d,attfl,attfl_d,attcn,attcn_d,attsub,attsub_d,ddd,tembro,x,attfr,attfr_d,atttl,atttl_d,atttr,atttr_d,mute;
 
void setup() {
  Wire.begin();Serial.begin(9600);
  lcd.begin(16, 2);lcd.createChar(0,a1);lcd.createChar(1,a2);
  pinMode(A0,INPUT); // menu
  pinMode(A1,INPUT); // +
  pinMode(A2,INPUT); // -
  pinMode(A3,INPUT); // input
  vol = EEPROM.read(0);in = EEPROM.read(1);bass = EEPROM.read(2)-7;mid = EEPROM.read(3)-7;treb = EEPROM.read(4)-7;
  attfl = EEPROM.read(5)-14;attcn = EEPROM.read(7)-14;attsub = EEPROM.read(8)-14;ddd = EEPROM.read(9);tembro = EEPROM.read(10);
  attfr = EEPROM.read(11)-14;atttl = EEPROM.read(12)-14;atttr = EEPROM.read(13)-14;
  delay(500);
  audio2();
}
 
void loop() {
   if(analogRead(A0)>900&&mute!=1){menu++;cl();time=millis();w=1;if(menu>7){menu=0;}}// меню
 
/////////////////////////////// volume ///////////////////////////////////////////////
 if(menu==0){
   if(analogRead(A1)>900){vol++;w=1;if(vol>79){vol=79;}audio2();cl();time=millis();}// 79 максимальная громкость  
   if(analogRead(A2)>900){vol--;w=1;if(vol<0){vol=0;}audio2();cl();time=millis();}// 0 минимум громкости 
    lcd.setCursor(0,0);lcd.print("Volume   ");
    lcd.print(-79+vol);lcd.setCursor(13,0);lcd.print("dB");vol_d=vol/2-15;
   if(vol_d>=0){for(z=0;z<=vol_d;z++){lcd.setCursor(z/2,1);lcd.write((uint8_t)0);}}
   if((vol_d)%2==0){lcd.setCursor(z/2,1);lcd.write((uint8_t)1);}
   lcd.setCursor(13,1);lcd.print(vol);lcd.print(" ");}
 /////////////////////////////////////////////////////////////////////////////////////
 
  /////////////////////// индикация тембр НЧ + управление кнопками -14...14 дБ ///////////////////
   if(menu==1){
   if(analogRead(A1)>900){bass++;w=1;if(bass>7){bass=7;}audio2();cl();time=millis();} 
   if(analogRead(A2)>900){bass--;w=1;if(bass<-7){bass=-7;}audio2();cl();time=millis();}
  lcd.setCursor(0,0);lcd.print("Bass      ");
  lcd.print(bass*2);lcd.setCursor(13,0);lcd.print("dB");bass_d=bass+7;
   if(bass_d>=0){for(z=0;z<=bass_d;z++){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)0);}}
   if((bass_d)%2==0){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)1);}}
 ////////////////////////////////////////////////////////////////////////////////////
 
   /////////////////////// индикация тембр CЧ + управление кнопками -14...14 дБ ///////////////////
   if(menu==2){
   if(analogRead(A1)>900){mid++;w=1;if(mid>7){mid=7;}audio2();cl();time=millis();} 
   if(analogRead(A2)>900){mid--;w=1;if(mid<-7){mid=-7;}audio2();cl();time=millis();}
  lcd.setCursor(0,0);lcd.print("Middle    ");
  lcd.print(mid*2);lcd.setCursor(13,0);lcd.print("dB");mid_d=mid+7;
   if(mid_d>=0){for(z=0;z<=mid_d;z++){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)0);}}
   if((mid_d)%2==0){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)1);}}
 ////////////////////////////////////////////////////////////////////////////////////
 
    /////////////////////// индикация тембр BЧ + управление кнопками -14...14 дБ ///////////////////
   if(menu==3){
   if(analogRead(A1)>900){treb++;w=1;if(treb>7){treb=7;}audio2();cl();time=millis();} 
   if(analogRead(A2)>900){treb--;w=1;if(treb<-7){treb=-7;}audio2();cl();time=millis();}
  lcd.setCursor(0,0);lcd.print("Treble    ");
  lcd.print(treb*2);lcd.setCursor(13,0);lcd.print("dB");treb_d=treb+7;
   if(treb_d>=0){for(z=0;z<=treb_d;z++){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)0);}}
   if((treb_d)%2==0){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)1);}}
 ////////////////////////////////////////////////////////////////////////////////////
 
//////////////////////////////////// rock pop classic //////////////////////      
  if(menu==4){
    if(analogRead(A1)>900){tembro++;w=1;if(tembro>4){tembro=0;}cl();time=millis();} 
    if(analogRead(A2)>900){tembro--;w=1;if(tembro<0){tembro=4;}cl();time=millis();}
    lcd.setCursor(0,0);lcd.print(" Preset timbre  ");
    if(tembro==0){lcd.setCursor(0,1);lcd.print("  manual mode  ");}
    if(tembro==1){lcd.setCursor(0,1);lcd.print("      ROCK     ");bass=4,mid=-2;treb=5;x=1;}
    if(tembro==2){lcd.setCursor(0,1);lcd.print("      POP      ");bass=-3,mid=3;treb=-2;x=1;}
    if(tembro==3){lcd.setCursor(0,1);lcd.print("    CLASSIC    ");bass=0,mid=0;treb=-2;x=1;}
    if(tembro==4){lcd.setCursor(0,1);lcd.print("    default    ");bass=0,mid=0;treb=0;x=1;}
    if(x==1){audio2();x=0;}
  }
////////////////////////////////////////////////////////////////////////////////
 
  /////////////////////// ATT FL ///////////////////
   if(menu==5){
   if(analogRead(A1)>900){attfl++;w=1;if(attfl>0){attfl=0;}audio2();cl();time=millis();} 
   if(analogRead(A2)>900){attfl--;w=1;if(attfl<-14){attfl=-14;}audio2();cl();time=millis();}
  lcd.setCursor(0,0);lcd.print("ATT FL   ");
  lcd.print(attfl);lcd.setCursor(13,0);lcd.print("dB");attfl_d=attfl+14;
   if(attfl_d>=0){for(z=0;z<=attfl_d;z++){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)0);}}
   if((attfl_d)%2==0){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)1);}}
 ////////////////////////////////////////////////////////////////////////////////////
 
   /////////////////////// ATT FR ///////////////////
   if(menu==6){
   if(analogRead(A1)>900){attfr++;w=1;if(attfr>0){attfr=0;}audio2();cl();time=millis();} 
   if(analogRead(A2)>900){attfr--;w=1;if(attfr<-14){attfr=-14;}audio2();cl();time=millis();}
  lcd.setCursor(0,0);lcd.print("ATT FR   ");
  lcd.print(attfr);lcd.setCursor(13,0);lcd.print("dB");attfr_d=attfr+14;
   if(attfr_d>=0){for(z=0;z<=attfr_d;z++){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)0);}}
   if((attfr_d)%2==0){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)1);}}
 ////////////////////////////////////////////////////////////////////////////////////
 
 
 //////////////////////////// 3d ///////////////////////////////////////////////
 if(menu==7){
   if(analogRead(A1)>900){ddd++;w=1;if(ddd>1){ddd=0;}audio2();cl();time=millis();} 
   if(analogRead(A2)>900){ddd--;w=1;if(ddd<0){ddd=1;}audio2();cl();time=millis();}
   lcd.setCursor(0,0); if(ddd==0){lcd.print("     3D  ON  ");}else{lcd.print("     3D  OFF  ");}
 }
 

//////////// mute ////////////////////////
  if(mute==1&&(analogRead(A1)>900||analogRead(A2)>900)){mute=0;menu=0;audio2();cl();}  
  if(analogRead(A1)>900&&analogRead(A2)>900){mute=1;menu=100;audio2();cl();}
  if(mute==1){lcd.setCursor(0,0);lcd.print("      MUTE      ");delay(300);}
 
 
 
///////////////////////////////eeprom//////////////////////////////////////////////// 
  if(millis()-time>10000&& w==1&&mute==0){
     EEPROM.update(0,vol);EEPROM.update(1,in);EEPROM.update(2,bass+7);EEPROM.update(3,mid+7);EEPROM.update(4,treb+7);
     EEPROM.update(5,attfl+14);EEPROM.update(7,attcn+14);EEPROM.update(8,attsub+14);EEPROM.update(9,ddd);EEPROM.update(10,tembro);
     EEPROM.update(11,attfr+14);EEPROM.update(12,atttl+14);EEPROM.update(13,atttr+14);
     menu=0;w=0;cl();}
/////////////////////////////////////////////////////////////////////////////////////
}// loop
 
 
void cl(){delay(300);lcd.clear();}

 
void audio2(){
  pt1.setFront_lk_att(abs(attfl));// att front L
  pt1.setFront_rk_att(abs(attfr));// att front R
  pt1.setCenter_att(abs(attcn));  // att center
  pt1.setRear_lk_att(abs(atttl)); // att rear L
  pt1.setRear_rk_att(abs(atttr)); // att rear R
  pt1.setSub_att(abs(attsub));     // att sub
  pt1.setFunc(mute,ddd,0); // mute,3d,тембр on/off
  pt1.setBass(bass);            // BASS    -14...0...14 dB (int -7...0...7)
  pt1.setMiddle(mid);          // MIDDLE  -14...0...14 dB (int -7...0...7)
  pt1.setTreble(treb);          // TREBLE  -14...0...14 dB (int -7...0...7)
  pt1.setVol(vol); // 0...79
}
