#include <ESP8266WiFi.h>
#include <WiFiClientSecure.h> 
#include <Wire.h>
#include <UTFT.h>
#include <SPI.h>
#include <DS3231.h>//https://github.com/jarzebski/Arduino-DS3231/archive/master.zip
DS3231 vrem;// Связываем объект clock с библиотекой DS3231
RTCDateTime DateTime;// Определяем сущность структуры RTCDateTime (описанной в библиотеке DS3231) для хранения считанных с часов даты и времени

 UTFT myGLCD ( ILI9341_S5P, 13, 14, 15, 0, 12 );//SDI (MOSI), SCK, CS, RESET, DC == D7 D5 D8 D3 D6
 extern uint8_t SmallRusFont[];
 extern uint8_t BigRusFont[];
const uint8_t utf8_rus_charmap[] PROGMEM = {'A',128,'B',129,130,'E',131,132,133,134,135,'K',136,'M','H','O',137,'P','C','T',138,139,'X',140,141,
142,143,144,145,146,147,148,149,'a',150,151,152,153,'e',154,155,156,157,158,159,160,161,162,'o',163,'p','c',164,'y',165,'x',166,167,168,169,170,
171,172,173,174,175};
char * den[7] = {"ПОН","ВТР","СРД","ЧЕТ","ПЯТ","СУБ","ВСК"};
char * mes[12] = {"ЯНВАРЯ","ФЕВРАЛЯ","МАРТА","АПРЕЛЯ","МАЯ","ИЮНЯ","ИЮЛЯ","АВГУСТА","СЕНТЯБРЯ","ОКТЯБРЯ","НОЯБРЯ","ДЕКАБРЯ"};

 
const char* ssid = "Keenetic-9009";
const char* password = "32481975";
char host[] = "export.yandex.ru"; 
const int port = 443;
const char fingerprint[] PROGMEM = "F3 DB F7 38 AA 71 13 15 1E E8 53 FC 0F 29 8C AB 3D F4 80 9F"; 
int w=1,i,w1=1,y,y01,y02;
unsigned long times;
String line;
String Link;
 
void setup ( ) { Wire.begin();  vrem.begin();// Инициализируем работу с объектом библиотеки DS3231
  myGLCD.InitLCD(0);myGLCD.fillRect(0,0,320,240);myGLCD.setFont(BigRusFont);myGLCD.clrScr();myGLCD.setColor(0,0,0); // первоначальные настройки экрана
 // myGLCD.setBrightness(16);myGLCD.setContrast(64);
  //  vrem.setDateTime(__DATE__, __TIME__); // Устанавливаем время на часах, основываясь на времени компиляции скетча
    Serial.begin(9600); delay(1000);
    WiFi.mode(WIFI_STA); WiFi.begin(ssid, password);
   while (WiFi.status() != WL_CONNECTED) {delay(1000);
    myGLCD.setColor(0xffff);printRus(myGLCD,"Connecting...",0,0,0);}
 //   printRus(myGLCD,ssid,0,15,0);Serial.print("IP address: ");Serial.println(WiFi.localIP());delay(3000);
    myGLCD.fillScr(0x0000);myGLCD.setColor(0x0000);myGLCD.setBackColor(0x0000);
}
 
void loop(){ to_Timer();delay(100);
  if(DateTime.minute==0&&DateTime.second==0||DateTime.minute==30&&DateTime.second==0||w==1){
    i++;
 
    WiFiClientSecure client;
    Serial.printf("Using fingerprint '%s'\n", fingerprint);
     client.setFingerprint(fingerprint);
     client.setTimeout(1000); // 5 Seconds
     delay(1000); while((!client.connect(host, port))){delay(100);}
 
     Link = "/bar/reginfo.xml?region=66";
     client.print(String("GET ") + Link + " HTTP/1.1\r\n" +
               "Host: " + host + "\r\n" +               
               "Connection: close\r\n\r\n");Serial.println("request sent");delay(1000);
 
  while (client.connected()) {String line = client.readStringUntil('\n');if (line == "\r") {Serial.println("headers received");break;}}
  delay(1000);while (client.available()) {line = client.readStringUntil('\r'); 
 
         myGLCD.setColor(0xffff);  
 
         int a;a =line.indexOf("<temperature class");
         printRus(myGLCD,"Темп_2",10,90,0);myGLCD.printNumI(line.substring(a+45, a+90).toInt(),130,90,2);printRus(myGLCD,"C",200,90,0);
 
         myGLCD.drawLine(5,115,235,115);
 
         a =line.indexOf("<torr>"); 
         myGLCD.setColor(0xfdfd);printRus(myGLCD,"Давление",10,125,0);myGLCD.setColor(0xffff);myGLCD.printNumI(line.substring(a+6, a+15).toInt(),170,125,3);//printRus(myGLCD,"C",200,125,0);
 
         a =line.indexOf("<dampness>"); 
         myGLCD.setColor(0xcdcd);printRus(myGLCD,"Влажность",10,150,0);myGLCD.setColor(0xffff);myGLCD.printNumI(line.substring(a+10, a+15).toInt(),155,150,3);printRus(myGLCD,"%",200,150,0);
 
         a =line.indexOf("<wind_speed>"); 
         myGLCD.setColor(0xeded);printRus(myGLCD,"Скор.ветра",10,175,0);myGLCD.setColor(0xffff);myGLCD.printNumI(line.substring(a+12, a+15).toInt(),140,175,2);printRus(myGLCD,"м/с",180,175,0);
 
         a =line.indexOf("<sun_rise>"); 
         myGLCD.setColor(0xdddd);printRus(myGLCD,"Восход",10,200,0);myGLCD.setColor(0xffff);myGLCD.print(line.substring(a+10, a+15),145,200,0);
 
         a =line.indexOf("<sunset>"); 
         myGLCD.setColor(0xdddd);printRus(myGLCD,"Закат",10,225,0);myGLCD.setColor(0xffff);myGLCD.print(line.substring(a+8, a+13),145,225);
 
         a =line.indexOf("<observation>"); 
         myGLCD.setFont(SmallRusFont);myGLCD.setColor(0xbbbb);myGLCD.setColor(0xffff);myGLCD.print(line.substring(a+13, a+32),CENTER,255,0);
 
         myGLCD.setColor(0xffff);  myGLCD.drawLine(5,280,235,280);
 
         myGLCD.setFont(SmallRusFont);
         myGLCD.setColor(0xf000);printRus(myGLCD,"pogoda.yandex.ru",CENTER,285,0);
         myGLCD.setColor(0xcdcd);printRus(myGLCD,"Количество запросов",20,300,0);myGLCD.printNumI(i,200,300);
  }}w=0;
  }//loop
 
 void to_Timer(){
       DateTime = vrem.getDateTime();   // Считываем c часов текущие значения даты и времени в сущность DateTime
       myGLCD.setFont(BigRusFont);myGLCD.setColor(0xffff);
 
       if(DateTime.hour<10){myGLCD.printNumI(0,57,10);y02=15;}
       else{y02=0;}myGLCD.printNumI(DateTime.hour, 57+y02, 10);printRus(myGLCD,":", 90, 10,0);
       // минуты
       if(DateTime.minute<10){myGLCD.printNumI(0,105,10);y01=15;}
       else{y01=0;}myGLCD.printNumI(DateTime.minute, 105+y01, 10);printRus(myGLCD,":", 135, 10,0);
       //секунды
       if(DateTime.second<10){myGLCD.printNumI(0,150,10);y=15;}
       else{y=0;}myGLCD.printNumI(DateTime.second, 150+y, 10);
       
       if(DateTime.second==0||w==1){myGLCD.setFont(SmallRusFont);myGLCD.setColor(0xcdcd);printRus(myGLCD,den[DateTime.dayOfWeek-1], 50,35,0);
       myGLCD.setColor(0xcdcd);myGLCD.printNumI(DateTime.day, 95,35,2);
       myGLCD.setColor(0xcdcd);printRus(myGLCD,mes[DateTime.month-1], 130,35,0);
       
       
       myGLCD.setColor(0xffff);myGLCD.drawLine(5,55,235,55);  
       myGLCD.setFont(BigRusFont);myGLCD.setColor(200,200,200);printRus(myGLCD,"Темп_1",10,65,0);myGLCD.printNumF(vrem.readTemperature(),1,130,65);printRus(myGLCD,"C",200,65,0);}
  }

  void printRus(UTFT rus,char *st, int x, int y_r, int deg){
 int stl, i_r;
 stl = strlen(st);
 if (rus.orient==PORTRAIT){
    if (x==RIGHT) x=(rus.disp_x_size+1)-(stl*rus.cfont.x_size);
    if (x==CENTER) x=((rus.disp_x_size+1)-(stl*rus.cfont.x_size))/2;
 } else {
  if (x==RIGHT) x=(rus.disp_y_size+1)-(stl*rus.cfont.x_size);
  if (x==CENTER) x=((rus.disp_y_size+1)-(stl*rus.cfont.x_size))/2;
 }
 uint8_t utf_high_byte = 0;
 uint8_t ch, ch_pos = 0;
 for (i_r = 0; i_r < stl; i_r++) {
  ch = st[i_r];
   if ( ch >= 128) {
     if ( utf_high_byte == 0 && (ch ==0xD0 || ch == 0xD1)) {
         utf_high_byte = ch;
      continue;
     } else {
     if ( utf_high_byte == 0xD0) {
    if (ch == 0x81) { //Ё
      ch = 6;
    } else {
    if(ch <= 0x95) {
       ch -= 0x90;
    } else if( ch < 0xB6){
    ch -= (0x90 - 1);
    } else {
    ch -= (0x90 - 2);
    }}
    ch = pgm_read_byte(utf8_rus_charmap + ch);
    } else if (utf_high_byte == 0xD1) {
           if (ch == 0x91) {//ё
           ch = 39;
       } else {
        ch -= 0x80;
        ch += 50;
       }
           ch = pgm_read_byte(utf8_rus_charmap + ch);
    }
    utf_high_byte = 0;
   }
   } else {
     utf_high_byte = 0;
     }
     if (deg==0) {rus.printChar(ch, x + (ch_pos * (rus.cfont.x_size)), y_r);} else {
          rus.rotateChar(ch, x, y_r, ch_pos, deg);
        }
      ++ch_pos;
 }
};
