#include <Wire.h>
#include <PT2322.h>
#include <PT2323.h>
#include <LiquidCrystal.h>
#include <EEPROM.h>
#include <Encoder.h>
#include <MsTimer2.h>
#include <boarddefs.h>
#include <IRremote.h>
 PT2322 pt; PT2323 pt0; 
  Encoder myEnc(9, 8);//CLK, DT подключение энкодера
  IRrecv irrecv(13); // указываем вывод модуля IR приемника
   decode_results ir;
 LiquidCrystal lcd(7, 6, 2, 3, 4, 5);// RS,E,D4,D5,D6,D7 подключение LCD
   byte a1[8]={0b00000,0b10101,0b10101,0b10101,0b10101,0b10101,0b10101,0b00000};
   byte a2[8]={0b00000,0b10100,0b10100,0b10100,0b10100,0b10100,0b10100,0b00000};
   byte a3[8]={0b00000,0b10000,0b10000,0b10000,0b10000,0b10000,0b10000,0b00000};
    unsigned long newPosition,time,oldPosition  = -999;
   int menu,menu2,w,vol,vol_d,z,z0,z1,in,bass,bass_d,mid,mid_d,treb,treb_d,attfl,attfl_d,attcn,attcn_d,attsub,attsub_d,ddd,tembro,x,attfr,attfr_d,atttl,atttl_d,atttr,atttr_d,mute;
   int g1,g2,inn;
   
void setup() {
  Wire.begin();Serial.begin(9600);irrecv.enableIRIn(); // запускаем модуль IR
  lcd.begin(16, 2);lcd.createChar(0,a1);lcd.createChar(1,a2);lcd.createChar(2,a3);
  pinMode(A0,INPUT); // menu кнопка энкодера 
  pinMode(12,INPUT); // MUTE
  pinMode(11,INPUT); // IN
  MsTimer2::set(2, to_Timer);MsTimer2::start();
   vol = EEPROM.read(0)-79;in = EEPROM.read(1);bass = EEPROM.read(2)-7;mid = EEPROM.read(3)-7;treb = EEPROM.read(4)-7;
  attfl = EEPROM.read(5)-14;attcn = EEPROM.read(7)-14;attsub = EEPROM.read(8)-14;ddd = EEPROM.read(9);tembro = EEPROM.read(10);
  attfr = EEPROM.read(11)-14;atttl = EEPROM.read(12)-14;atttr = EEPROM.read(13)-14;
  delay(500);
  audio();audio_in();
}
 void to_Timer(){newPosition = myEnc.read()/4;}
 
 void loop(){delay(10);
  if(analogRead(A0)<900){menu++;cl1();myEnc.write(0);time=millis();w=1;if(menu>11){menu=0;}}// меню
  if ( irrecv.decode( &ir )) {Serial.print("0x");Serial.println( ir.value,HEX);time=millis();w=1;irrecv.resume();}// IR приемник  
  
   if(ir.value==0x2FDD02F){menu++;g1=0;g2=0;cl1();time=millis();w=1;if(menu>11){menu=0;}}// меню кнопка CH+
   if(ir.value==0x2FD32CD){menu--;g1=0;g2=0;cl1();time=millis();w=1;if(menu<0){menu=11;}}// меню кнопка CH-
   if(ir.value==0x2FDB24D){menu=0;g1=0;g2=0;cl1();time=millis();w=1;}// меню кнопка CH (menu===0)
   if(ir.value==0x2FDEA15){inn=1;g1=0;g2=0;time=millis();w=1;}//  кнопка IN 
 //////////////////////////////////////// Громкость -79...0 дБ //////////////////////////////////////
 if(menu==0){   
     if(ir.value==0x2FD906F){vol++;g1=1;g2=0;cl();time=millis();w=1;}// кнопка VOL+  0xFFA857
     if(ir.value==0xFFFFFFFF and g1==1){vol++;g2=0;cl();time=millis();w=1;}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){vol--;g1=0;g2=1;cl();time=millis();w=1;}// кнопка VOL-
     if(ir.value==0xFFFFFFFF and g2==1){vol--;g1=0;cl();time=millis();w=1;}// кнопка <<<<<<
     if(vol>79){vol=79;}if(vol<0){vol=0;}
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    vol=vol+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(vol>79){vol=79;}if(vol<0){vol=0;}audio();}
  lcd.setCursor(0,0);lcd.print("Volume  ");
  lcd.print(" ");lcd.print(-79+vol);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");vol_d=vol-32;
   for(z=0,z0=0,z1=0;z<=vol_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1,1);lcd.print("    ");}}
   if(z1==3){lcd.setCursor(z0,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0,1);lcd.write((uint8_t)2);}}
 //////////////////////////////////////// Тембр НЧ +-14 дБ //////////////////////////////////////
 if(menu==1){
     if(ir.value==0x2FD906F){bass++;g1=1;g2=0;cl();time=millis();w=1;}// кнопка VOL+
     if(ir.value==0xFFFFFFFF and g1==1){bass++;g2=0;cl();time=millis();w=1;}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){bass--;g1=0;g2=1;cl();time=millis();w=1;}// кнопка VOL-
     if(ir.value==0xFFFFFFFF and g2==1){bass--;g1=0;cl();time=millis();w=1;}// кнопка <<<<<<
   if(bass<-7){bass=-7;}if(bass>7){bass=7;}
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    bass=bass+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(bass<-7){bass=-7;}if(bass>7){bass=7;}audio();}
  lcd.setCursor(0,0);lcd.print("Bass    ");
  lcd.print(" ");lcd.print(bass*2);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");bass_d=(bass+7)*2;
   for(z=0,z0=0,z1=0;z<=bass_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("    ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}}   
 //////////////////////////////////////// Тембр CЧ +-14 дБ //////////////////////////////////////
 if(menu==2){
     if(ir.value==0x2FD906F){mid++;g1=1;g2=0;cl();time=millis();w=1;}// кнопка VOL+
     if(ir.value==0xFFFFFFFF and g1==1){mid++;g2=0;cl();time=millis();w=1;}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){mid--;g1=0;g2=1;cl();time=millis();w=1;}// кнопка VOL-
     if(ir.value==0xFFFFFFFF and g2==1){mid--;g1=0;cl();time=millis();w=1;}// кнопка <<<<<<
   if(mid<-7){mid=-7;}if(mid>7){mid=7;}
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    mid=mid+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(mid<-7){mid=-7;}if(mid>7){mid=7;}audio();}
  lcd.setCursor(0,0);lcd.print("Middle  ");
  lcd.print(" ");lcd.print(mid*2);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");mid_d=(mid+7)*2;
   for(z=0,z0=0,z1=0;z<=mid_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("   ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}} 
 //////////////////////////////////////// Тембр BЧ +-14 дБ //////////////////////////////////////
 if(menu==3){
     if(ir.value==0x2FD906F){treb++;g1=1;g2=0;cl();time=millis();w=1;}// кнопка VOL+
     if(ir.value==0xFFFFFFFF and g1==1){treb++;g2=0;cl();time=millis();w=1;}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){treb--;g1=0;g2=1;cl();time=millis();w=1;}// кнопка VOL-
     if(ir.value==0xFFFFFFFF and g2==1){treb--;g1=0;cl();time=millis();w=1;}// кнопка <<<<<<
   if(treb<-7){treb=-7;}if(treb>7){treb=7;}
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    treb=treb+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(treb<-7){treb=-7;}if(treb>7){treb=7;}audio();}
  lcd.setCursor(0,0);lcd.print("Treble  ");
  lcd.print(" ");lcd.print(treb*2);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");treb_d=(treb+7)*2;
   for(z=0,z0=0,z1=0;z<=treb_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("    ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}}    
   //////////////////////////////////// rock pop classic //////////////////////      
  if(menu==4){
     if(ir.value==0x2FD906F){tembro++;g1=1;g2=0;cl();time=millis();w=1;}// кнопка VOL+
     if(ir.value==0xFFFFFFFF and g1==1){tembro++;g2=0;cl();time=millis();w=1;}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){tembro--;g1=0;g2=1;cl();time=millis();w=1;}// кнопка VOL-
     if(ir.value==0xFFFFFFFF and g2==1){tembro--;g1=0;cl();time=millis();w=1;}// кнопка <<<<<<
      if(tembro>4){tembro=0;}if(tembro<0){tembro=4;}
     if (newPosition != oldPosition) {
    oldPosition = newPosition;
    tembro=tembro+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(tembro>4){tembro=0;}if(tembro<0){tembro=4;}}
    lcd.setCursor(0,0);lcd.print(" Preset timbre  ");
    if(tembro==0){lcd.setCursor(0,1);lcd.print("  manual mode  ");}
    if(tembro==1){lcd.setCursor(0,1);lcd.print("      ROCK     ");bass=4,mid=-2;treb=5;x=1;}
    if(tembro==2){lcd.setCursor(0,1);lcd.print("      POP      ");bass=-3,mid=3;treb=-2;x=1;}
    if(tembro==3){lcd.setCursor(0,1);lcd.print("    CLASSIC    ");bass=0,mid=0;treb=-2;x=1;}
    if(tembro==4){lcd.setCursor(0,1);lcd.print("    default    ");bass=0,mid=0;treb=0;x=1;}
    if(x==1){audio();x=0;}
  }
   
  /////////////////////// ATT FL ///////////////////
   if(menu==5){
     if(ir.value==0x2FD906F){attfl++;g1=1;g2=0;cl();time=millis();w=1;}// кнопка VOL+
     if(ir.value==0xFFFFFFFF and g1==1){attfl++;g2=0;cl();time=millis();w=1;}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){attfl--;g1=0;g2=1;cl();time=millis();w=1;}// кнопка VOL-
     if(ir.value==0xFFFFFFFF and g2==1){attfl--;g1=0;cl();time=millis();w=1;}// кнопка <<<<<<
   if(attfl<-14){attfl=-14;}if(attfl>0){attfl=0;}
     
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    attfl=attfl+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(attfl<-14){attfl=-14;}if(attfl>0){attfl=0;}audio();}
  lcd.setCursor(0,0);lcd.print("ATT FL   ");
  lcd.print(" ");lcd.print(attfl);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");attfl_d=(attfl+14)*2;
   for(z=0,z0=0,z1=0;z<=attfl_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("    ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}}  
  /////////////////////// ATT FR ///////////////////
   if(menu==6){
     if(ir.value==0x2FD906F){attfr++;g1=1;g2=0;cl();time=millis();w=1;}// кнопка VOL+
     if(ir.value==0xFFFFFFFF and g1==1){attfr++;g2=0;cl();time=millis();w=1;}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){attfr--;g1=0;g2=1;cl();time=millis();w=1;}// кнопка VOL-
     if(ir.value==0xFFFFFFFF and g2==1){attfr--;g1=0;cl();time=millis();w=1;}// кнопка <<<<<<
   if(attfr<-14){attfr=-14;}if(attfr>0){attfr=0;}
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    attfr=attfr+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(attfr<-14){attfr=-14;}if(attfr>0){attfr=0;}audio();}
  lcd.setCursor(0,0);lcd.print("ATT FR   ");
  lcd.print(" ");lcd.print(attfr);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");attfr_d=(attfr+14)*2;
   for(z=0,z0=0,z1=0;z<=attfr_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("    ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}}  
  /////////////////////// ATT TL ///////////////////
  if(menu==7){
     if(ir.value==0x2FD906F){atttl++;g1=1;g2=0;cl();time=millis();w=1;}// кнопка VOL+
     if(ir.value==0xFFFFFFFF and g1==1){atttl++;g2=0;cl();time=millis();w=1;}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){atttl--;g1=0;g2=1;cl();time=millis();w=1;}// кнопка VOL-
     if(ir.value==0xFFFFFFFF and g2==1){atttl--;g1=0;cl();time=millis();w=1;}// кнопка <<<<<<
   if(atttl<-14){atttl=-14;}if(atttl>0){atttl=0;}
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    atttl=atttl+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(atttl<-14){atttl=-14;}if(atttl>0){atttl=0;}audio();}
  lcd.setCursor(0,0);lcd.print("ATT TL   ");
  lcd.print(" ");lcd.print(atttl);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");atttl_d=(atttl+14)*2;
   for(z=0,z0=0,z1=0;z<=atttl_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("    ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}} 
 /////////////////////// ATT TR ///////////////////
  if(menu==8){
     if(ir.value==0x2FD906F){atttr++;g1=1;g2=0;cl();time=millis();w=1;}// кнопка VOL+
     if(ir.value==0xFFFFFFFF and g1==1){atttr++;g2=0;cl();time=millis();w=1;}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){atttr--;g1=0;g2=1;cl();time=millis();w=1;}// кнопка VOL-
     if(ir.value==0xFFFFFFFF and g2==1){atttr--;g1=0;cl();time=millis();w=1;}// кнопка <<<<<<
   if(atttr<-14){atttr=-14;}if(atttr>0){atttr=0;}
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    atttr=atttr+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(atttr<-14){atttr=-14;}if(atttr>0){atttr=0;}audio();}
  lcd.setCursor(0,0);lcd.print("ATT TR   ");
  lcd.print(" ");lcd.print(atttr);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");atttr_d=(atttr+14)*2;
   for(z=0,z0=0,z1=0;z<=atttr_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("    ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}} 
 /////////////////////// ATT CN ///////////////////
    if(menu==9){
     if(ir.value==0x2FD906F){attcn++;g1=1;g2=0;cl();time=millis();w=1;}// кнопка VOL+
     if(ir.value==0xFFFFFFFF and g1==1){attcn++;g2=0;cl();time=millis();w=1;}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){attcn--;g1=0;g2=1;cl();time=millis();w=1;}// кнопка VOL-
     if(ir.value==0xFFFFFFFF and g2==1){attcn--;g1=0;cl();time=millis();w=1;}// кнопка <<<<<<
      if(attcn<-14){attcn=-14;}if(attcn>0){attcn=0;}
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    attcn=attcn+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(attcn<-14){attcn=-14;}if(attcn>0){attcn=0;}audio();}
  lcd.setCursor(0,0);lcd.print("ATT CN   ");
  lcd.print(" ");lcd.print(attcn);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");attcn_d=(attcn+14)*2;
   for(z=0,z0=0,z1=0;z<=attcn_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("    ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}}  
  /////////////////////// ATT SUB ///////////////////
     if(menu==10){
     if(ir.value==0x2FD906F){attsub++;g1=1;g2=0;cl();time=millis();w=1;}// кнопка VOL+
     if(ir.value==0xFFFFFFFF and g1==1){attsub++;g2=0;cl();time=millis();w=1;}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){attsub--;g1=0;g2=1;cl();}// кнопка VOL-
     if(ir.value==0xFFFFFFFF and g2==1){attsub--;g1=0;cl();time=millis();w=1;}// кнопка <<<<<<
       if(attsub<-14){attsub=-14;}if(attsub>0){attsub=0;time=millis();w=1;}
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    attsub=attsub+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(attsub<-14){attsub=-14;}if(attsub>0){attsub=0;}audio();}
  lcd.setCursor(0,0);lcd.print("ATT SUB  ");
  lcd.print(" ");lcd.print(attsub);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");attsub_d=(attsub+14)*2;
   for(z=0,z0=0,z1=0;z<=attsub_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("    ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}}  
   
  //////////////////////////// 3d ///////////////////////////////////////////////
 if(menu==11){
     if(ir.value==0x2FD906F){ddd++;g1=1;g2=0;cl1();time=millis();w=1;}// кнопка VOL+
     if(ir.value==0xFFFFFFFF and g1==1){ddd++;g2=0;cl1();time=millis();w=1;}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){ddd--;g1=0;g2=1;cl1();}// кнопка VOL-
     if(ir.value==0xFFFFFFFF and g2==1){ddd--;g1=0;cl1();time=millis();w=1;}// кнопка <<<<<<
   if(ddd<0){ddd=1;}if(ddd>1){ddd=0;}
   if (newPosition != oldPosition) {
    oldPosition = newPosition;
    ddd=ddd+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;if(ddd<0){ddd=1;}if(ddd>1){ddd=0;}audio();}
   lcd.setCursor(0,0); if(ddd==0){lcd.print("     3D  ON  ");}else{lcd.print("     3D  OFF  ");} }  
 //////////// mute ////////////////////////
  if(mute==1&&(digitalRead(12)==HIGH)){mute=0;menu=0;audio();cl1();}  
  if(digitalRead(12)==HIGH){mute=1;menu=100;audio();cl1();}
  if(mute==1){lcd.setCursor(0,0);lcd.print("      MUTE      ");delay(300);}
   
   ////////////////////////////////////////////////////////////////////////////////
  if(digitalRead(11)==HIGH||inn==1){in++;if(in>4){in=0;}audio_in();cl1();lcd.setCursor(0,0);lcd.print("    INPUT  ");lcd.print(in+1);delay(2000);time=millis();w=1;inn=0;}// in
   
   if(millis()-time>10000&& w==1&&mute==0){
     EEPROM.update(0,vol+79);EEPROM.update(1,in);EEPROM.update(2,bass+7);EEPROM.update(3,mid+7);EEPROM.update(4,treb+7);
     EEPROM.update(5,attfl+14);EEPROM.update(7,attcn+14);EEPROM.update(8,attsub+14);EEPROM.update(9,ddd);EEPROM.update(10,tembro);
     EEPROM.update(11,attfr+14);EEPROM.update(12,atttl+14);EEPROM.update(13,atttr+14);
     menu=0;w=0;cl();}
 
   
 }//loop
 
 void cl(){ir.value=0;delay(100);}
 void cl1(){ir.value=0;delay(300);lcd.clear();}
 void audio_in(){
  pt0.setInput(in); 
  pt0.setMute(0,0,0,0,0,0,0); 
  pt0.setFeature(1,1); 
}
 void audio(){
  pt.setFront_lk_att(abs(attfl));// att front L
  pt.setFront_rk_att(abs(attfr));// att front R
  pt.setCenter_att(abs(attcn));  // att center
  pt.setRear_lk_att(abs(atttl)); // att rear L
  pt.setRear_rk_att(abs(atttr)); // att rear R
  pt.setSub_att(abs(attsub));     // att sub
  pt.setFunc(mute,ddd,0); // mute,3d,тембр on/off
  pt.setBass(bass);            // BASS    -14...0...14 dB (int -7...0...7)
  pt.setMiddle(mid);          // MIDDLE  -14...0...14 dB (int -7...0...7)
  pt.setTreble(treb);          // TREBLE  -14...0...14 dB (int -7...0...7)
  pt.setVol(abs(vol)); // -79...0
}

