#include <Wire.h>
#include <PT2323.h>
#include <PT2322.h>
#include <LiquidCrystal.h>
#include <EEPROMex.h>
#include <IRremote.h>
 PT2323 pt0; 
 PT2322 pt1;
 IRrecv irrecv(12); // указываем вывод модуля IR приемника
 decode_results ir;
 LiquidCrystal lcd(7, 6, 2, 3, 4, 5);// RS,E,D4,D5,D6,D7 подключение LCD
   byte a1[8]={0b00000,0b11011,0b11011,0b11011,0b11011,0b11011,0b11011,0b00000};
   byte a2[8]={0b00000,0b11000,0b11000,0b11000,0b11000,0b11000,0b11000,0b00000};
   unsigned long time;
   int menu,w,vol,vol_d,z,in,bass,bass_d,mid,mid_d,treb,treb_d,attfl,attfl_d,attcn,attcn_d,attsub,attsub_d,ddd,tembro,x,attfr,attfr_d,atttl,atttl_d,atttr,atttr_d,mute,g1,g2,mut,power;
   int d_x,f1,f2;
void setup() {
  Wire.begin();Serial.begin(9600); irrecv.enableIRIn(); // запускаем модуль IR
  lcd.begin(16, 2);lcd.createChar(0,a1);lcd.createChar(1,a2);
  pinMode(A0,INPUT); // menu
  pinMode(A1,INPUT); // +
  pinMode(A2,INPUT); // -
  pinMode(A3,INPUT); // input
  pinMode(13,OUTPUT);
  vol = EEPROM.read(0);in = EEPROM.read(1);bass = EEPROM.read(2)-7;mid = EEPROM.read(3)-7;treb = EEPROM.read(4)-7;
  attfl = EEPROM.read(5)-14;attcn = EEPROM.read(7)-14;attsub = EEPROM.read(8)-14;ddd = EEPROM.read(9);tembro = EEPROM.read(10);
  attfr = EEPROM.read(11)-14;atttl = EEPROM.read(12)-14;atttr = EEPROM.read(13)-14;
  delay(500);
  audio1();audio2();
}
 
void loop() {
   if ( irrecv.decode( &ir )) {delay(200);Serial.print("0x");Serial.println( ir.value,HEX);time=millis();w=1;;irrecv.resume();}// IR приемник
//   if(ir.value==0xFFA05F){menu++;cl1();if(menu>11){menu=0;}}// меню кнопка 0xFFA05F
   
   if(ir.value==0x2FDB24D){menu++;f1=1;cl1();if(menu>11){menu=0;}}// кнопка > 0xFFA05F  ///0x2FDB24D
   if(ir.value==0xFFFFFFFF&&f1==1){menu++;cl1();if(menu>11){menu=0;}}// кнопка >>>>>>
  // if(ir.value<0xFFFFFFFF){f1=0;}
   
   
   if(ir.value==0xFF20DF){in++;if(in>4){in=0;}audio1();cl1();lcd.setCursor(0,0);lcd.print("    INPUT  ");lcd.print(in+1);delay(2000);time=millis();w=1;}// in кнопка 0xFF20DF
   if(ir.value==0xFF609F){menu=4;cl1();}// ROCK/POP/CLASSIC кнопка 0xFF609F
   if(ir.value==0xFF10EF){menu=5;cl1();}// LF кнопка 0xFF10EF
   if(ir.value==0xFF30CF){menu=6;cl1();}// RF кнопка 0xFF30CF
   if(ir.value==0xFF906F){menu=7;cl1();}// TL кнопка 0xFF906F
   if(ir.value==0xFFB04F){menu=8;cl1();}// TR кнопка 0xFFB04F
   if(ir.value==0xFF50AF){menu=9;cl1();}// center кнопка 0xFF50AF
   if(ir.value==0xFF708F){menu=10;cl1();}// sub кнопка 0xFF708F
   
   ///0x807F30CF
   
   if(ir.value==0x807F30CF&&d_x==0){ddd=1;audio2();cl1();d_x=1;lcd.setCursor(0,0);lcd.print("     3D  ON  ");delay(1000);}// mute кнопка 0x807F30CF
   if(ir.value==0x807F30CF&&d_x==1){ddd=0;audio2();cl1();d_x=0;lcd.setCursor(0,0);lcd.print("     3D  OFF  ");delay(1000);}// mute кнопка 0x807F30CF
   
   
   if(ir.value==0xFF40BF&&mut==0){mute=1;menu=100;audio1();cl1();mut=1;}// mute кнопка 0xFF40BF
   if(ir.value==0xFF40BF&&mut==1){mute=0;menu=0;audio1();cl1();mut=0;}// mute кнопка 0xFF40BF
   
   if(ir.value==0xFF00FF&&power==0){mute=1;menu=100;audio1();cl1();power=1;digitalWrite(13,HIGH);}// mute кнопка 0xFF40BF
   if(ir.value==0xFF00FF&&power==1){mute=0;menu=0;audio1();cl1();power=0;digitalWrite(13,LOW);}// mute кнопка 0xFF40BF
   
   
   if(analogRead(A0)>900&&mute!=1){menu++;cl();time=millis();w=1;if(menu>11){menu=0;}}// меню
 
/////////////////////////////// volume ///////////////////////////////////////////////
 if(menu==0){
   if(ir.value==0x2fd906f){vol++;f1=0;g1=1;g2=0;w=1;audio2();cl1();time=millis();}// кнопка > 0xFF08F7
   if(ir.value==0xFFFFFFFF and g1==1){vol++;g2=0;w=1;audio2();cl1();time=millis();}// кнопка >>>>>>
   if(ir.value==0x2fdf20d){vol--;f1=0;g1=0;g2=1;audio2();cl1();time=millis();}// кнопка < 0xFF8877
   if(ir.value==0xFFFFFFFF and g2==1){vol--;g1=0;audio2();cl1();time=millis();}// кнопка <<<<<<
   if(vol>79){vol=79;}if(vol<0){vol=0;}
   
   if(analogRead(A1)>900){vol++;w=1;if(vol>79){vol=79;}audio2();cl();time=millis();}// 79 максимальная громкость  
   if(analogRead(A2)>900){vol--;w=1;if(vol<0){vol=0;}audio2();cl();time=millis();}// 0 минимум громкости 
    lcd.setCursor(0,0);lcd.print("Volume   ");
    lcd.print(-79+vol);lcd.setCursor(13,0);lcd.print("dB");vol_d=vol/2-15;
   if(vol_d>=0){for(z=0;z<=vol_d;z++){lcd.setCursor(z/2,1);lcd.write((uint8_t)0);}}
   if((vol_d)%2==0){lcd.setCursor(z/2,1);lcd.write((uint8_t)1);}
   lcd.setCursor(13,1);lcd.print(vol);}
 /////////////////////////////////////////////////////////////////////////////////////
 
  /////////////////////// индикация тембр НЧ + управление кнопками -14...14 дБ ///////////////////
   if(menu==1){
   if(ir.value==0xFF08F7){bass++;f1=0;g1=1;g2=0;w=1;if(bass>7){bass=7;}if(bass<-7){bass=-7;}audio2();tembro=0;cl1();time=millis();}// кнопка > 0xFF08F7
   if(ir.value==0xFFFFFFFF and g1==1){bass++;g2=0;w=1;if(bass>7){bass=7;}if(bass<-7){bass=-7;}audio2();tembro=0;cl1();time=millis();}// кнопка >>>>>>
   if(ir.value==0xFF8877){bass--;f1=0;g1=0;g2=1;if(bass>7){bass=7;}if(bass<-7){bass=-7;}audio2();cl1();tembro=0;time=millis();}// кнопка < 0xFF8877
   if(ir.value==0xFFFFFFFF and g2==1){bass--;g1=0;if(bass>7){bass=7;}if(bass<-7){bass=-7;}audio2();cl1();tembro=0;time=millis();}// кнопка <<<<<<
   
     
   if(analogRead(A1)>900){bass++;w=1;if(bass>7){bass=7;}audio2();tembro=0;cl();time=millis();} 
   if(analogRead(A2)>900){bass--;w=1;if(bass<-7){bass=-7;}audio2();tembro=0;cl();time=millis();}
  lcd.setCursor(0,0);lcd.print("Bass      ");
  lcd.print(bass*2);lcd.setCursor(13,0);lcd.print("dB");bass_d=bass+7;
   if(bass_d>=0){for(z=0;z<=bass_d;z++){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)0);}}
   if((bass_d)%2==0){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)1);}}
 ////////////////////////////////////////////////////////////////////////////////////
 
   /////////////////////// индикация тембр CЧ + управление кнопками -14...14 дБ ///////////////////
   if(menu==2){
   if(ir.value==0xFF08F7){mid++;f1=0;g1=1;g2=0;w=1; if(mid>7){mid=7;}if(mid<-7){mid=-7;} audio2();cl1();tembro=0;time=millis();}// кнопка > 0xFF08F7
   if(ir.value==0xFFFFFFFF and g1==1){mid++;g2=0;w=1; if(mid>7){mid=7;}if(mid<-7){mid=-7;} audio2();tembro=0;cl1();time=millis();}// кнопка >>>>>>
   if(ir.value==0xFF8877){mid--;f1=0;g1=0;g2=1; if(mid>7){mid=7;}if(mid<-7){mid=-7;} audio2();cl1();tembro=0;time=millis();}// кнопка < 0xFF8877
   if(ir.value==0xFFFFFFFF and g2==1){mid--;g1=0; if(mid>7){mid=7;}if(mid<-7){mid=-7;} audio2();cl1();tembro=0;time=millis();}// кнопка <<<<<<
 
     
   if(analogRead(A1)>900){mid++;w=1;if(mid>7){mid=7;}audio2();cl();tembro=0;time=millis();} 
   if(analogRead(A2)>900){mid--;w=1;if(mid<-7){mid=-7;}audio2();cl();tembro=0;time=millis();}
  lcd.setCursor(0,0);lcd.print("Middle    ");
  lcd.print(mid*2);lcd.setCursor(13,0);lcd.print("dB");mid_d=mid+7;
   if(mid_d>=0){for(z=0;z<=mid_d;z++){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)0);}}
   if((mid_d)%2==0){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)1);}}
 ////////////////////////////////////////////////////////////////////////////////////
 
    /////////////////////// индикация тембр BЧ + управление кнопками -14...14 дБ ///////////////////
   if(menu==3){
   if(ir.value==0xFF08F7){treb++;f1=0;g1=1;g2=0;w=1;if(treb>7){treb=7;}if(treb<-7){treb=-7;}audio2();cl1();tembro=0;time=millis();}// кнопка > 0xFF08F7
   if(ir.value==0xFFFFFFFF and g1==1){treb++;g2=0;w=1;if(treb>7){treb=7;}if(treb<-7){treb=-7;}audio2();cl1();tembro=0;time=millis();}// кнопка >>>>>>
   if(ir.value==0xFF8877){treb--;f1=0;g1=0;g2=1;if(treb>7){treb=7;}if(treb<-7){treb=-7;}audio2();cl1();tembro=0;time=millis();}// кнопка < 0xFF8877
   if(ir.value==0xFFFFFFFF and g2==1){treb--;g1=0;if(treb>7){treb=7;}if(treb<-7){treb=-7;}audio2();cl1();tembro=0;time=millis();}// кнопка <<<<<<
     
     
   if(analogRead(A1)>900){treb++;w=1;if(treb>7){treb=7;}audio2();cl();tembro=0;time=millis();} 
   if(analogRead(A2)>900){treb--;w=1;if(treb<-7){treb=-7;}audio2();cl();tembro=0;time=millis();}
  lcd.setCursor(0,0);lcd.print("Treble    ");
  lcd.print(treb*2);lcd.setCursor(13,0);lcd.print("dB");treb_d=treb+7;
   if(treb_d>=0){for(z=0;z<=treb_d;z++){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)0);}}
   if((treb_d)%2==0){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)1);}}
 ////////////////////////////////////////////////////////////////////////////////////
 
//////////////////////////////////// rock pop classic //////////////////////      
  if(menu==4){
   if(ir.value==0xFF08F7){tembro++;f1=0;g1=1;g2=0;w=1;audio2();cl1();time=millis();}// кнопка > 0xFF08F7
   if(ir.value==0xFFFFFFFF and g1==1){tembro++;g2=0;w=1;audio2();cl1();time=millis();}// кнопка >>>>>>
   if(ir.value==0xFF8877){tembro--;f1=0;g1=0;g2=1;audio2();cl1();time=millis();}// кнопка < 0xFF8877
   if(ir.value==0xFFFFFFFF and g2==1){tembro--;g1=0;audio2();cl1();time=millis();}// кнопка <<<<<<
   if(tembro>4){tembro=0;}if(tembro<0){tembro=4;}
    
    if(analogRead(A1)>900){tembro++;w=1;if(tembro>4){tembro=0;}cl();time=millis();} 
    if(analogRead(A2)>900){tembro--;w=1;if(tembro<0){tembro=4;}cl();time=millis();}
    lcd.setCursor(0,0);lcd.print(" Preset timbre  ");
    if(tembro==0){lcd.setCursor(0,1);lcd.print("  manual mode  ");}
    if(tembro==1){lcd.setCursor(0,1);lcd.print("      ROCK     ");bass=4,mid=-2;treb=5;x=1;}
    if(tembro==2){lcd.setCursor(0,1);lcd.print("      POP      ");bass=-3,mid=3;treb=-2;x=1;}
    if(tembro==3){lcd.setCursor(0,1);lcd.print("    CLASSIC    ");bass=0,mid=0;treb=-2;x=1;}
    if(tembro==4){lcd.setCursor(0,1);lcd.print("    default    ");bass=0,mid=0;treb=0;x=1;}
    if(x==1){audio2();x=0;}
  }
////////////////////////////////////////////////////////////////////////////////
 
  /////////////////////// ATT FL ///////////////////
   if(menu==5){
   if(ir.value==0xFF08F7){attfl++;f1=0;g1=1;g2=0;w=1;audio2();cl1();time=millis();}// кнопка > 0xFF08F7
   if(ir.value==0xFFFFFFFF and g1==1){attfl++;g2=0;w=1;audio2();cl1();time=millis();}// кнопка >>>>>>
   if(ir.value==0xFF8877){attfl--;f1=0;g1=0;g2=1;audio2();cl1();time=millis();}// кнопка < 0xFF8877
   if(ir.value==0xFFFFFFFF and g2==1){attfl--;g1=0;audio2();cl1();time=millis();}// кнопка <<<<<<
   if(attfl>0){attfl=0;}if(attfl<-14){attfl=-14;}
     
     
   if(analogRead(A1)>900){attfl++;w=1;if(attfl>0){attfl=0;}audio2();cl();time=millis();} 
   if(analogRead(A2)>900){attfl--;w=1;if(attfl<-14){attfl=-14;}audio2();cl();time=millis();}
  lcd.setCursor(0,0);lcd.print("ATT FL   ");
  lcd.print(attfl);lcd.setCursor(13,0);lcd.print("dB");attfl_d=attfl+14;
   if(attfl_d>=0){for(z=0;z<=attfl_d;z++){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)0);}}
   if((attfl_d)%2==0){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)1);}}
 ////////////////////////////////////////////////////////////////////////////////////
 
   /////////////////////// ATT FR ///////////////////
   if(menu==6){
   if(ir.value==0xFF08F7){attfr++;f1=0;g1=1;g2=0;w=1;audio2();cl1();time=millis();}// кнопка > 0xFF08F7
   if(ir.value==0xFFFFFFFF and g1==1){attfr++;g2=0;w=1;audio2();cl1();time=millis();}// кнопка >>>>>>
   if(ir.value==0xFF8877){attfr--;f1=0;g1=0;g2=1;audio2();cl1();time=millis();}// кнопка < 0xFF8877
   if(ir.value==0xFFFFFFFF and g2==1){attfr--;g1=0;audio2();cl1();time=millis();}// кнопка <<<<<<
   if(attfr>0){attfr=0;}if(attfr<-14){attfr=-14;}
     
     
   if(analogRead(A1)>900){attfr++;w=1;if(attfr>0){attfr=0;}audio2();cl();time=millis();} 
   if(analogRead(A2)>900){attfr--;w=1;if(attfr<-14){attfr=-14;}audio2();cl();time=millis();}
  lcd.setCursor(0,0);lcd.print("ATT FR   ");
  lcd.print(attfr);lcd.setCursor(13,0);lcd.print("dB");attfr_d=attfr+14;
   if(attfr_d>=0){for(z=0;z<=attfr_d;z++){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)0);}}
   if((attfr_d)%2==0){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)1);}}
 ////////////////////////////////////////////////////////////////////////////////////
 
 /////////////////////// ATT TL ///////////////////
   if(menu==7){
   if(ir.value==0xFF08F7){atttl++;f1=0;g1=1;g2=0;w=1;audio2();cl1();time=millis();}// кнопка > 0xFF08F7
   if(ir.value==0xFFFFFFFF and g1==1){atttl++;g2=0;w=1;audio2();cl1();time=millis();}// кнопка >>>>>>
   if(ir.value==0xFF8877){atttl--;f1=0;g1=0;g2=1;audio2();cl1();time=millis();}// кнопка < 0xFF8877
   if(ir.value==0xFFFFFFFF and g2==1){atttl--;g1=0;audio2();cl1();time=millis();}// кнопка <<<<<<
   if(atttl>0){atttl=0;}if(atttl<-14){atttl=-14;}
     
   if(analogRead(A1)>900){atttl++;w=1;if(atttl>0){atttl=0;}audio2();cl();time=millis();} 
   if(analogRead(A2)>900){atttl--;w=1;if(atttl<-14){atttl=-14;}audio2();cl();time=millis();}
  lcd.setCursor(0,0);lcd.print("ATT TL   ");
  lcd.print(atttl);lcd.setCursor(13,0);lcd.print("dB");atttl_d=atttl+14;
   if(atttl_d>=0){for(z=0;z<=atttl_d;z++){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)0);}}
   if((atttl_d)%2==0){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)1);}}
 ////////////////////////////////////////////////////////////////////////////////////
 
 
 /////////////////////// ATT TR ///////////////////
   if(menu==8){
   if(ir.value==0xFF08F7){atttr++;f1=0;g1=1;g2=0;w=1;audio2();cl1();time=millis();}// кнопка > 0xFF08F7
   if(ir.value==0xFFFFFFFF and g1==1){atttr++;g2=0;w=1;audio2();cl1();time=millis();}// кнопка >>>>>>
   if(ir.value==0xFF8877){atttr--;f1=0;g1=0;g2=1;audio2();cl1();time=millis();}// кнопка < 0xFF8877
   if(ir.value==0xFFFFFFFF and g2==1){atttr--;g1=0;audio2();cl1();time=millis();}// кнопка <<<<<<
   if(atttr>0){atttr=0;}if(atttr<-14){atttr=-14;}
     
     
   if(analogRead(A1)>900){atttr++;w=1;if(atttr>0){atttr=0;}audio2();cl();time=millis();} 
   if(analogRead(A2)>900){atttr--;w=1;if(atttr<-14){atttr=-14;}audio2();cl();time=millis();}
  lcd.setCursor(0,0);lcd.print("ATT TR   ");
  lcd.print(atttr);lcd.setCursor(13,0);lcd.print("dB");atttr_d=atttr+14;
   if(atttr_d>=0){for(z=0;z<=atttr_d;z++){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)0);}}
   if((atttr_d)%2==0){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)1);}}
 ////////////////////////////////////////////////////////////////////////////////////
 
  /////////////////////// ATT CN ///////////////////
   if(menu==9){
   if(ir.value==0xFF08F7){attcn++;f1=0;g1=1;g2=0;w=1;audio2();cl1();time=millis();}// кнопка > 0xFF08F7
   if(ir.value==0xFFFFFFFF and g1==1){attcn++;g2=0;w=1;audio2();cl1();time=millis();}// кнопка >>>>>>
   if(ir.value==0xFF8877){attcn--;f1=0;g1=0;g2=1;audio2();cl1();time=millis();}// кнопка < 0xFF8877
   if(ir.value==0xFFFFFFFF and g2==1){attcn--;g1=0;audio2();cl1();time=millis();}// кнопка <<<<<<
   if(attcn>0){attcn=0;}if(attcn<-14){attcn=-14;}
     
     
   if(analogRead(A1)>900){attcn++;w=1;if(attcn>0){attcn=0;}audio2();cl();time=millis();} 
   if(analogRead(A2)>900){attcn--;w=1;if(attcn<-14){attcn=-14;}audio2();cl();time=millis();}
  lcd.setCursor(0,0);lcd.print("ATT CN   ");
  lcd.print(attcn);lcd.setCursor(13,0);lcd.print("dB");attcn_d=attcn+14;
   if(attcn_d>=0){for(z=0;z<=attcn_d;z++){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)0);}}
   if((attcn_d)%2==0){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)1);}}
 ////////////////////////////////////////////////////////////////////////////////////
 
   /////////////////////// ATT SUB ///////////////////
   if(menu==10){
   if(ir.value==0xFF08F7){attsub++;f1=0;g1=1;g2=0;w=1;audio2();cl1();time=millis();}// кнопка > 0xFF08F7
   if(ir.value==0xFFFFFFFF and g1==1){attsub++;g2=0;w=1;audio2();cl1();time=millis();}// кнопка >>>>>>
   if(ir.value==0xFF8877){attsub--;f1=0;g1=0;g2=1;audio2();cl1();time=millis();}// кнопка < 0xFF8877
   if(ir.value==0xFFFFFFFF and g2==1){attsub--;g1=0;audio2();cl1();time=millis();}// кнопка <<<<<<
   if(attsub>0){attsub=0;}if(attsub<-14){attsub=-14;}
     
   if(analogRead(A1)>900){attsub++;w=1;if(attsub>0){attsub=0;}audio2();cl();time=millis();} 
   if(analogRead(A2)>900){attsub--;w=1;if(attsub<-14){attsub=-14;}audio2();cl();time=millis();}
  lcd.setCursor(0,0);lcd.print("ATT SUB  ");
  lcd.print(attsub);lcd.setCursor(13,0);lcd.print("dB");attsub_d=attsub+14;
   if(attsub_d>=0){for(z=0;z<=attsub_d;z++){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)0);}}
   if((attsub_d)%2==0){lcd.setCursor(z/2+4,1);lcd.write((uint8_t)1);}}
 ////////////////////////////////////////////////////////////////////////////////////
 
 //////////////////////////// 3d ///////////////////////////////////////////////
 if(menu==11){
   if(ir.value==0xFF08F7){ddd++;f1=0;g1=1;g2=0;w=1;audio2();cl1();time=millis();}// кнопка > 0xFF08F7
   if(ir.value==0xFFFFFFFF and g1==1){ddd++;g2=0;w=1;audio2();cl1();time=millis();}// кнопка >>>>>>
   if(ir.value==0xFF8877){ddd--;f1=0;g1=0;g2=1;audio2();cl1();time=millis();}// кнопка < 0xFF8877
   if(ir.value==0xFFFFFFFF and g2==1){ddd--;g1=0;audio2();cl1();time=millis();}// кнопка <<<<<<
   if(ddd>1){ddd=0;}audio2();if(ddd<0){ddd=1;}audio2();
   
   if(analogRead(A1)>900){ddd++;w=1;if(ddd>1){ddd=0;}audio2();cl();time=millis();} 
   if(analogRead(A2)>900){ddd--;w=1;if(ddd<0){ddd=1;}audio2();cl();time=millis();}
   lcd.setCursor(0,0); if(ddd==0){lcd.print("     3D  ON  ");}else{lcd.print("     3D  OFF  ");}
 }
 
 ////////////////////////////////////////////////////////////////////////////////
  if(analogRead(A3)>900){in++;if(in>4){in=0;}audio1();cl();lcd.setCursor(0,0);lcd.print("    INPUT  ");lcd.print(in+1);delay(2000);time=millis();w=1;}// in
//////////// mute ////////////////////////
  if(mute==1&&(analogRead(A1)>900||analogRead(A2)>900)){mute=0;menu=0;audio1();cl();}  
  if(analogRead(A1)>900&&analogRead(A2)>900){mute=1;menu=100;audio1();cl();}
  if(mute==1&&power==0){lcd.setCursor(0,0);lcd.print("      MUTE      ");delay(300);}
  if(mute==1&&power==1){lcd.setCursor(0,0);lcd.print("     POWER      ");delay(300);}
 
 
 
///////////////////////////////eeprom//////////////////////////////////////////////// 
  if(millis()-time>10000&& w==1&&mute==0){
     EEPROM.update(0,vol);EEPROM.update(1,in);EEPROM.update(2,bass+7);EEPROM.update(3,mid+7);EEPROM.update(4,treb+7);
     EEPROM.update(5,attfl+14);EEPROM.update(7,attcn+14);EEPROM.update(8,attsub+14);EEPROM.update(9,ddd);EEPROM.update(10,tembro);
     EEPROM.update(11,attfr+14);EEPROM.update(12,atttl+14);EEPROM.update(13,atttr+14);
     menu=0;w=0;cl();}
/////////////////////////////////////////////////////////////////////////////////////
}// loop
 
 
void cl(){delay(200);lcd.clear();}
void cl1(){ir.value=0;delay(100);lcd.clear();}
void audio1(){
  pt0.setInput(in); 
  pt0.setMute(0,0,0,0,0,0,mute); 
  pt0.setFeature(1,1); 
}
 
void audio2(){
  pt1.setFront_lk_att(abs(attfl));// att front L
  pt1.setFront_rk_att(abs(attfr));// att front R
  pt1.setCenter_att(abs(attcn));  // att center
  pt1.setRear_lk_att(abs(atttl)); // att rear L
  pt1.setRear_rk_att(abs(atttr)); // att rear R
  pt1.setSub_att(abs(attsub));     // att sub
  pt1.setFunc(0,ddd,0); // mute,3d,тембр on/off
  pt1.setBass(bass);            // BASS    -14...0...14 dB (int -7...0...7)
  pt1.setMiddle(mid);          // MIDDLE  -14...0...14 dB (int -7...0...7)
  pt1.setTreble(treb);          // TREBLE  -14...0...14 dB (int -7...0...7)
  pt1.setVol(vol); // 0...79
}
