#include <Wire.h>
#include <MsTimer2.h>
#include <LiquidCrystal.h>
#include <Encoder.h>
#include <EEPROMex.h>
#include <TDA7313.h>
#include <boarddefs.h>
#include <IRremote.h>
  IRrecv irrecv(10); // указываем вывод модуля IR приемника
  TDA7313 tda;decode_results ir;
  Encoder myEnc(9, 8);//CLK, DT подключение энкодера
  LiquidCrystal lcd(7, 6, 2, 3, 4, 5);// RS,E,D4,D5,D6,D7 подключение LCD
   byte a1[8]={0b00000,0b10101,0b10101,0b10101,0b10101,0b10101,0b10101,0b00000};
   byte a2[8]={0b00000,0b10100,0b10100,0b10100,0b10100,0b10100,0b10100,0b00000};
   byte a3[8]={0b00000,0b10000,0b10000,0b10000,0b10000,0b10000,0b10000,0b00000};
   unsigned long newPosition,time,time1,oldPosition  = -999;
   int vol,w1,w2=1,gr1,gr2,vol_d,menu,w,z,z0,z1,bass_d,bass,treb_d,treb,i,menu1,in,gain,gain1,gain2,gain3,loud,lr,rr,lf,rf;
 
void setup(){ 
  Serial.begin(9600);Wire.begin();irrecv.enableIRIn(); // запускаем модуль IR
  lcd.begin(16, 2);lcd.createChar(0,a1);lcd.createChar(1,a2);lcd.createChar(2,a3);
   pinMode(A0,INPUT);// КНОПКА ЭНКОДЕРA
   pinMode(12,INPUT);// КНОПКА IN
     MsTimer2::set(3, to_Timer);MsTimer2::start();
     vol = EEPROM.read(0);bass = EEPROM.read(1)-7;treb = EEPROM.read(2)-7;in = EEPROM.read(3);
     gain1 = EEPROM.read(4);gain2 = EEPROM.read(5);gain3 = EEPROM.read(6);loud = EEPROM.read(7);
     lr = EEPROM.read(8);rr = EEPROM.read(9);lf = EEPROM.read(10);rf = EEPROM.read(11);
      if(in==0){gain=gain1;}
      if(in==1){gain=gain2;}
      if(in==2){gain=gain3;}
      lcd.setCursor(0,0);lcd.print("    TDA 7313    ");
      lcd.setCursor(0,1);lcd.print("      V2.0      ");
      delay(1000);audio();
}
 
void to_Timer(){newPosition = myEnc.read()/4;}
 
void loop(){
  if ( irrecv.decode( &ir )) {Serial.print("0x");Serial.println( ir.value,HEX);time1=millis();time=millis();w=1;w1=1;irrecv.resume();}// IR приемник
  if((analogRead(A0)<900)&&menu1==0){menu++;cl();myEnc.write(0);i++;time=millis();w=1;w2=1;if(menu>2){menu=0;}}// меню
  if((analogRead(A0)>900)){i=0;}if(i>3){cl();lcd.print("     MENU 2     ");delay(500);cl();menu1=1;menu=100;}
  if((analogRead(A0)<900)&&menu1>0){menu1++;cl();myEnc.write(0);time=millis();w=1;w2=1;if(menu1>6){cl();menu1=0;menu=0;}}// меню 1
  
     if(ir.value==0x2FDD02F){menu++;gr1=0;gr2=0;cl();time=millis();w=1;w2=1;if(menu>2){menu=0;}}// меню кнопка вверх
     if(ir.value==0x2FD32CD){menu--;gr1=0;gr2=0;cl();time=millis();w=1;w2=1;if(menu<0){menu=2;}}// меню кнопка вниз
     
     if(ir.value==0x2FDEA15){in++;gr1=0;gr2=0;cl();time=millis();w=1;w2=1;if(in>2){in=0;}audio();lcd.setCursor(0,0);lcd.print("IN ");lcd.print(in+1);delay(1000);}//  кнопка IN
     
  //////////////////////////////////////// Volume 0...63 дБ //////////////////////////////////////
 if(menu==0){
     if(ir.value==0x2FD906F){vol++;gr1=1;gr2=0;cl1();w2=1;if(vol<0){vol=0;}if(vol>63){vol=63;}audio();}// кнопка > 
     if(ir.value==0xFFFFFFFF and gr1==1){vol++;gr2=0;cl1();w2=1;if(vol<0){vol=0;}if(vol>63){vol=63;}audio();}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){vol--;gr1=0;gr2=1;cl1();w2=1;if(vol<0){vol=0;}if(vol>63){vol=63;}audio();}// кнопка <
     if(ir.value==0xFFFFFFFF and gr2==1){vol--;gr1=0;cl1();w2=1;if(vol<0){vol=0;}if(vol>63){vol=63;}audio();}// кнопка <<<<<<
   
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    vol=vol+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;w2=1;if(vol>63){vol=63;}if(vol<0){vol=0;}audio();}
 
  lcd.setCursor(0,0);lcd.print("Volume ");lcd.print(" ");
  lcd.print(-78.75+(float)vol*1.25,2);lcd.print(" ");lcd.setCursor(14,0);lcd.print("dB");vol_d=vol-15;
   if(w2==1){
   for(z=0,z0=0,z1=0;z<=vol_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1,1);lcd.print("   ");}}
   if(z1==3){lcd.setCursor(z0,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0,1);lcd.write((uint8_t)2);}w2=0;}}
//////////////////////////////////////////////////////////////////////////////////////////////////////
 
 /////////////////////// индикация тембр НЧ -14...14 дБ ///////////////////
   if(menu==1){ 
     if(ir.value==0x2FD906F){bass++;gr1=1;gr2=0;cl1();w2=1;if(bass>7){bass=7;}if(bass<-7){bass=-7;}audio();}// кнопка > 
     if(ir.value==0xFFFFFFFF and gr1==1){bass++;gr2=0;cl1();w2=1;if(bass>7){bass=7;}if(bass<-7){bass=-7;}audio();}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){bass--;gr1=0;gr2=1;cl1();w2=1;if(bass>7){bass=7;}if(bass<-7){bass=-7;}audio();}// кнопка < 
     if(ir.value==0xFFFFFFFF and gr2==1){bass--;gr1=0;cl1();w2=1;if(bass>7){bass=7;}if(bass<-7){bass=-7;}audio();}// кнопка <<<<<<
   
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    bass=bass+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;w2=1;if(bass>7){bass=7;}if(bass<-7){bass=-7;}audio();} 
   lcd.setCursor(0,0);lcd.print("Bass    ");
   lcd.print(" ");lcd.print(bass*2);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");bass_d=bass*2+15;
   if(w2==1){
   for(z=0,z0=0,z1=0;z<=bass_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("   ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}w2=0;}}
/////////////////////////////////////////////////////////////////////////////////////
 
 /////////////////////// индикация тембр ВЧ -14...14 дБ ///////////////////
   if(menu==2){
 if(ir.value==0x2FD906F){treb++;gr1=1;gr2=0;cl1();w2=1;if(treb>7){treb=7;}if(treb<-7){treb=-7;}audio();}// кнопка > 
     if(ir.value==0xFFFFFFFF and gr1==1){treb++;gr2=0;cl1();w2=1;if(treb>7){treb=7;}if(treb<-7){treb=-7;}audio();}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){treb--;gr1=0;gr2=1;cl1();w2=1;if(treb>7){treb=7;}if(treb<-7){treb=-7;}audio();}// кнопка < 
     if(ir.value==0xFFFFFFFF and gr2==1){treb--;gr1=0;cl1();w2=1;if(treb>7){treb=7;}if(treb<-7){treb=-7;}audio();}// кнопка <<<<<<
   
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    treb=treb+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;w2=1;if(treb>7){treb=7;}if(treb<-7){treb=-7;}audio();} 
   lcd.setCursor(0,0);lcd.print("Treble  ");
   lcd.print(" ");lcd.print(treb*2);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");treb_d=treb*2+15;
   if(w2==1){
   for(z=0,z0=0,z1=0;z<=treb_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("   ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}w2=0;}}
/////////////////////////////////////////////////////////////////////////////////////
 
  if(digitalRead(12)==HIGH){in++;;cl();myEnc.write(0);time=millis();w=1;w2=1;if(in>2){in=0;}if(in<0){in=2;}audio();lcd.setCursor(0,0);lcd.print("IN ");lcd.print(in+1);delay(1000);}
 
///////////////////////////////////// GAIN //////////////////////////////////////////
 
 if(menu1==1){
      if(in==0){gain=gain1;}
      if(in==1){gain=gain2;}
      if(in==2){gain=gain3;}
 
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    gain=gain+newPosition;myEnc.write(0);newPosition=0;lcd.clear();time=millis();w=1;w2=1;if(gain>3){gain=3;}if(gain<0){gain=0;}audio();} 
 
      if(in==0){gain1=gain;}
      if(in==1){gain2=gain;}
      if(in==2){gain3=gain;}
    
  lcd.setCursor(0,0);lcd.print(" INPUT ");lcd.print(in+1);lcd.setCursor(0,1);lcd.print(" Gain ");lcd.print((float)gain*3.75);lcd.print(" dB ");
 }
 /////////////////////////////// LOUDNESS //////////////////////////////////////////
 
  if(menu1==2){
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    loud=loud+newPosition;myEnc.write(0);newPosition=0;lcd.clear();time=millis();w=1;w2=1;if(loud>1){loud=0;}if(loud<0){loud=1;}audio();}
    lcd.setCursor(0,0);lcd.print("LOUDNESS ");if(loud==1){lcd.print("ON ");}else{lcd.print("OFF");}
} 
////////////////////////////////// att  LR //////////////////////////////////////////////
 
   if(menu1==3){
     if (newPosition != oldPosition) {
    oldPosition = newPosition;
    lr=lr-newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;w2=1;if(lr>31){lr=31;}if(lr<0){lr=0;}audio();} 
    lcd.setCursor(0,0);lcd.print("Speaker   ");lcd.print((float)-lr*1.25,2);lcd.print("  ");
    lcd.setCursor(0,1);lcd.print("LR");lcd.setCursor(14,1);lcd.print("dB");
     if(w2==1){
   for(z=0,z0=0,z1=0;z<=-lr+31;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("   ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}w2=0;}}
 ////////////////////////////////////////////////////////////////////////////////////////
 ////////////////////////////////// att  LF //////////////////////////////////////////////
 
   if(menu1==4){
     if (newPosition != oldPosition) {
    oldPosition = newPosition;
    lf=lf-newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;w2=1;if(lf>31){lf=31;}if(lf<0){lf=0;}audio();} 
    lcd.setCursor(0,0);lcd.print("Speaker   ");lcd.print((float)-lf*1.25,2);lcd.print("  ");
    lcd.setCursor(0,1);lcd.print("LF");lcd.setCursor(14,1);lcd.print("dB");
    if(w2==1){
   for(z=0,z0=0,z1=0;z<=-lf+31;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("   ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}w2=0;}}
 ////////////////////////////////////////////////////////////////////////////////////////
  ////////////////////////////////// att  RF //////////////////////////////////////////////
 
   if(menu1==5){
     if (newPosition != oldPosition) {
    oldPosition = newPosition;
    rf=rf-newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;w2=1;if(rf>31){rf=31;}if(rf<0){rf=0;}audio();} 
    lcd.setCursor(0,0);lcd.print("Speaker   ");lcd.print((float)-rf*1.25,2);lcd.print("  ");
    lcd.setCursor(0,1);lcd.print("RF");lcd.setCursor(14,1);lcd.print("dB");
    if(w2==1){
   for(z=0,z0=0,z1=0;z<=-rf+31;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("   ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}w2=0;}}
 ////////////////////////////////////////////////////////////////////////////////////////
   ////////////////////////////////// att  RR //////////////////////////////////////////////
 
   if(menu1==6){
     if (newPosition != oldPosition) {
    oldPosition = newPosition;
    rr=rr-newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;w2=1;if(rr>31){rr=31;}if(rr<0){rr=0;}audio();} 
    lcd.setCursor(0,0);lcd.print("Speaker   ");lcd.print((float)-rr*1.25,2);lcd.print(" ");
    lcd.setCursor(0,1);lcd.print("RR");lcd.setCursor(14,1);lcd.print("dB");
    if(w2==1){
   for(z=0,z0=0,z1=0;z<=-rr+31;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("   ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}w2=0;}}
 ////////////////////////////////////////////////////////////////////////////////////////
 
 
 if(millis()-time>10000 && w==1){
     EEPROM.update(0,vol);
     EEPROM.update(1,bass+7);
     EEPROM.update(2,treb+7);
     EEPROM.update(3,in);
     EEPROM.update(4,gain1);EEPROM.update(5,gain2);EEPROM.update(6,gain3);
     EEPROM.update(7,loud);
     EEPROM.update(8,lr);EEPROM.update(9,rr);EEPROM.update(10,lf);EEPROM.update(11,rf);
     menu1=0;lcd.clear();w=0,w2=1;menu=0;}
}
 
 void cl(){ir.value=0;delay(300);lcd.clear();}
 void cl1(){ir.value=0;delay(50);}
void audio(){
  tda.setVolume(vol); // громкость 0...63
  tda.setAttLR(lr);   // аттенюатор LR 0...31
  tda.setAttRR(rr);   // аттенюатор RR 0...31
  tda.setAttLF(lf);   // аттенюатор LF 0...31
  tda.setAttRF(rf);   // аттенюатор RF 0...31
  tda.setSwitch(in,loud,gain); // вход 0...2, тонкомпенсация 1 вкл 0 выкл, усиление 0...3
  tda.setBass(bass);    // тембр НЧ -7...+7
  tda.setTreble(treb);  // тембр ВЧ -7...+7
}
