/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class Image2Code {
    public Image2Code() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                JFrame jFrame = new JFrame("Image to lcd bitmap converter");
                jFrame.setDefaultCloseOperation(3);
                jFrame.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                jFrame.add((Component)new ThePanel(jFrame), gridBagConstraints);
                jFrame.pack();
                jFrame.setLocationRelativeTo(null);
                jFrame.setVisible(true);
            }
        });
    }

    public static void main(String[] stringArray) {
        new Image2Code();
    }

    public class ThePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Dimension dimension = new Dimension(1024, 768);
        private final JFrame jf;
        private BufferedImage master;
        private BufferedImage blackWhite;
        JLabel fromImg;
        JLabel bwImg;
        private JTextArea codeArea = new JTextArea();
        private float scaleFactor = 5.0f;
        private int maxImgWidth = 500;
        private int maxImgHeight = 300;

        @Override
        public Dimension getPreferredSize() {
            return this.dimension;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.dimension;
        }

        private BufferedImage scale(BufferedImage bufferedImage) {
            BufferedImage bufferedImage2 = null;
            float f = Math.min(this.scaleFactor, Math.min(1.0f * (float)this.maxImgWidth / (float)bufferedImage.getWidth(), 1.0f * (float)this.maxImgHeight / (float)bufferedImage.getHeight()));
            bufferedImage2 = bufferedImage.getColorModel() instanceof IndexColorModel ? new BufferedImage(Math.round(f * (float)bufferedImage.getWidth()), Math.round(f * (float)bufferedImage.getHeight()), bufferedImage.getType(), (IndexColorModel)bufferedImage.getColorModel()) : new BufferedImage(Math.round(f * (float)bufferedImage.getWidth()), Math.round(f * (float)bufferedImage.getHeight()), bufferedImage.getType());
            AffineTransformOp affineTransformOp = new AffineTransformOp(new AffineTransform(f, 0.0f, 0.0f, f, 0.0f, 0.0f), 1);
            affineTransformOp.filter(bufferedImage, bufferedImage2);
            return bufferedImage2;
        }

        private String getCodeFromImg(BufferedImage bufferedImage) {
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12);
            ColorConvertOp colorConvertOp = new ColorConvertOp(ColorSpace.getInstance(1003), null);
            colorConvertOp.filter(bufferedImage, bufferedImage2);
            DataBuffer dataBuffer = bufferedImage2.getRaster().getDataBuffer();
            int n = (bufferedImage.getWidth() + 7) / 8;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{\n");
            int n2 = 0;
            int n3 = dataBuffer.getSize();
            while (n2 < n3) {
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("0x" + Integer.toString(dataBuffer.getElem(n2++), 16) + (n2 != n3 ? "," : ""));
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append("};\n");
            return stringBuffer.toString();
        }

        void loadURL(URL uRL) {
            try {
                this.master = ImageIO.read(uRL);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.loadImage();
        }

        void loadFile(File file) {
            try {
                this.master = ImageIO.read(file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.loadImage();
        }

        void loadImage() {
            this.fromImg.setIcon(new ImageIcon(this.scale(this.master)));
            this.blackWhite = new BufferedImage(this.master.getWidth(), this.master.getHeight(), 12);
            ColorConvertOp colorConvertOp = new ColorConvertOp(ColorSpace.getInstance(1003), null);
            colorConvertOp.filter(this.master, this.blackWhite);
            this.bwImg.setIcon(new ImageIcon(this.scale(this.blackWhite)));
            this.codeArea.setText(this.getCodeFromImg(this.master));
            this.jf.pack();
        }

        public ThePanel(JFrame jFrame) {
            this.jf = jFrame;
            this.setLayout(new GridBagLayout());
            JButton jButton = new JButton("Choose file");
            jButton.setAlignmentX(0.5f);
            this.add((Component)jButton, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 256, 0, new Insets(0, 0, 0, 0), 0, 0));
            final JFileChooser jFileChooser = new JFileChooser();
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    switch (jFileChooser.showOpenDialog(ThePanel.this)) {
                        case 0: {
                            ThePanel.this.loadFile(jFileChooser.getSelectedFile());
                            break;
                        }
                    }
                }
            });
            JPanel jPanel = new JPanel(new FlowLayout(1));
            this.fromImg = new JLabel("Original image:", 10);
            this.fromImg.setHorizontalTextPosition(10);
            this.bwImg = new JLabel("binary image:", 10);
            this.bwImg.setHorizontalTextPosition(10);
            this.add((Component)this.fromImg, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 256, 2, new Insets(5, 0, 5, 5), 0, 0));
            this.add((Component)this.bwImg, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 256, 2, new Insets(5, 0, 5, 5), 0, 0));
            jPanel.add(new JLabel("Generated code:"));
            this.codeArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(this.codeArea, 20, 30);
            this.add((Component)new JLabel("Generated code:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)jScrollPane, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            URL uRL = this.getClass().getClassLoader().getResource("Adafruit.png");
            this.loadURL(uRL);
        }
    }
}

