# CyberLib
Fast library for Arduino from [cyber-place.ru](http://cyber-place.ru/showthread.php?t=550)

## Управление пинами: 
```c++
Dx_Out;  // установка пина Х как выход 
Dx_In; // установка пина Х  как вход 
Dx_Hihg; // установка высокого уровна на пине Х 
Dx_Low; // установка низкого уровня на пине Х 
Ax_Read; // чтение аналогового пина Х 
```
## SmallUart 
```c++
UART_Init(115200); //инициализация последовательного порта 
UART_ReadByte(byte)); //получить байт данных из последовательного порта 
UART_SendByte(byte); //отправить байт данных в последовательный порт 
UART_SendArray(array, size array); // Функция отправляет в UART порт, массив типа байт, максимальный объем которого не должен превышать 65535 байт, минимальный объем массива 1 байт. Можно также отправлять часть массива array-имя вашего массива, size array-число отправляемых байт массива 
```
## delay_us() и delay_ms() 
Функции `delay_us()` и `delay_ms()` можно применять в прерываниях, так как они не используют таймер, но не следует забывать, что точность этих функций зависит от использования в коде обработчиков прерываний. Если Вы не используете в коде прерывания, то и точность будет высокая 
```c++
delay_us(n); // где n - задержка в мкс, максимальная задержка может быть не больше 16000 мкс 
delay_ms(n); //где n - задержка в мс, максимальная задержка может быть не больше 65000 мс это равно 65 сек 
```
## Timer1
Настройку прерываний таймера можно настраивать от 6 мкс до 4000000 мкс (4 сек) с шагом 1 мкс. 
```c++
StartTimer1(handler, 1000);// запуск таймера, первый параметр это Ваш обработчик прерывания, второй параметр это время, может принимать значения от 6 до 4000000 
StopTimer1(); // Выключить таймер 
ResumeTimer1(); // возобновить отсчет после остановки 
RestartTimer1(); // перезапустить отсчет таймера заново 
```
## SPI
Увеличил пропускную способность в 1,85 раза, при работе на одной и той же частоте 
SPI теперь можно настроить и запустить одной строкой : 
```c++
StartSPI(0, 2, 1); 
```
Где первый параметр это режим mode от 0 до 3, второй параметр это делитель тактовой частоты, может принимать значения 2, 4, 8, 16, 32, 64, 128. Если Вы хотите выяснить частоту SPI то должны тактовую частоту контроллера 16000000 разделить на любой делитель из списка. И последний параметр это какой бит пойдет первым. Если 1, то первым пойдет старший бит, если 0, то первым пойдет младший бит. 
```c++
SendSPI(12); // Отправить байт данных в шину SPI  
MyData = ReadSPI(); // Получить байт данных
StopSPI(); // Выключить SPI
```
## EEPROM 
**Ограничение!** Адресует максимум 256 адресов для типа `byte`, для `word` максимум 128, для `long` максимум 64.

```c++
WriteEEPROM_Long(0, 4000000); // Сохранить значение 4000000 в EEPROM по адресу 0 тип Long 
uint32_t tmp = ReadEEPROM_Long(0); // Прочитать из EEPROM с адреса 0 значение типа Long
WriteEEPROM_Word(0, 4000); // Сохранить значение 4000 в EEPROM по адресу 0 тип Word 
uint16_t tmp=ReadEEPROM_Word(0); // Прочитать из EEPROM с адреса 0 значение типа Word 
WriteEEPROM_Byte(0, 200); // Сохранить значение 400 в EEPROM по адресу 0 тип Byte uint8_t tmp=ReadEEPROM_Byte(0); // Прочитать из EEPROM с адреса 0 значение типа Byte 
```
## Фильтр удаления шума и ложных срабатываний  
```c++
find_similar(Array, sizeArray, range); 
```
Функция возвращает наиболее часто встречаемое в массиве значение.

Параметры:
* Array - Указатель на проверяемый массив, массив может иметь тип `uint16_t` или `uint8_t` 
* sizeArray - длинна массива не более 256 элементов 
* range - предел погрешности (отклонение), может колебаться от 0 до 127, при значении 0 функция будет искать точные копии значений 

## beep 
```c++
beep(uint16_t dur, uint16_t frq); 
```
Генерирует звуковые колебания, на любом пине с заданной частотой и длительностью.

Параметры:
* dur - длительность от 50 мс до 65535 мс 
* frq - частота от 10 Гц до 2000 Гц 

## Soft Reset
```c++
reset(); // программный сброс контроллера  
```
При помощи этой функции можно отправить контроллер в ребут в любом месте выполняемой программы.

## Бесконечный цикл 
```c++
Start // Начало цикла 
End // Конец цикла 
```

## Работа со сторожевым таймером      
```c++
wdt_reset(); // обнулить сторожевой таймер 
wdt_disable(); // выключить сторожевой таймер 
wdt_enable(timeout); // Инициализация сторожевого таймера 
```
### Возможные значения timeout 
* `WDTO_15MS` 
* `WDTO_30MS`
* `WDTO_60MS`
* `WDTO_120MS` 
* `WDTO_250MS`
* `WDTO_500MS`
* `WDTO_1S`
* `WDTO_2S`
* `WDTO_4S`
* `WDTO_8S` 
