#include <Wire.h> 
#include <SPI.h>
#include <DHT.h>
#include <BMP085.h>
#include <OneWire.h>
#include <DallasTemperature.h>
#include <DS3231.h>//https://github.com/jarzebski/Arduino-DS3231/archive/master.zip
#include <PCD8544.h>
 PCD8544 lcd; // RST,CE,DC,DIN,CLK   VCC,BL,GND (3,4,5,6,7   +3.3V,200 OM +3.3V, GND)
 DHT dht(2, DHT11); // выход DATA подключен к цыфровому входу 2
 DS3231 clock;RTCDateTime DateTime;
 OneWire oneWire(A0);// вход датчика 18b20
 DallasTemperature temp(&oneWire);
 BMP085 dps = BMP085(); 
 static const byte gradus[] = { B00000110,B00001001,B00001001,B00000110,B00000000 };// градус
 static const byte herta[] = { B00011000,B00011000,B00011000,B00011000,B00011000 };// градус
 
long Temperature,Pressure;
int i;float t1,t2,p,h;
char * mes[12]{"/)&",",e&","Map$","A;p","Ma]","^_)`","^_{`","A&}","Ce)","Ok$","Ho*","#ek"};
char * den[7]{"!o)","B$p","Cp(","'$&","!*$","C@[","Bck"};
 
void setup(void) { 
  Serial.begin(9600);Wire.begin();
  dht.begin();
  temp.begin(); temp.setResolution(10);//10 бит   
  clock.begin();
  dps.init(); 
  lcd.begin(84, 48); 
  lcd.createChar(0, gradus);lcd.createChar(1, herta);
  lcd.setContrast(60);//  контрастность 0-127
  //  clock.setDateTime(__DATE__, __TIME__); // Устанавливаем время на часах, основываясь на времени компиляции скетча 
}          
 
void loop(void) { 
  DateTime=clock.getDateTime();   // Считываем c часов текущие значения даты и времени в сущность DateTime
  dps.getPressure(&Pressure); 
  dps.getTemperature(&Temperature);
  temp.requestTemperatures();
 
  lcd.setCursor(0,0);
  lcd.print(clock.dateFormat("H:i:s",DateTime));// выводим часы, минуты 
  lcd.print("  ");for(i=0;i<7;i++){if(DateTime.dayOfWeek==i){lcd.print(den[i-1]);}}lcd.print(" ");// день недели
  lcd.setCursor(5,1);
  lcd.print(DateTime.day);lcd.print(" "); // дата
  for(i=0;i<12;i++){if(DateTime.month==i){lcd.print(mes[i-1]);}}lcd.print(" "); // месяц
  lcd.print(DateTime.year);lcd.print(" "); // год
 
  if((DateTime.second/10)%2==0){ // каждые 2 секунды опрос температуры, давления и влажности
  t1=Temperature*0.1;
  t2=temp.getTempCByIndex(0);
  p=Pressure/133.3;}
  
  lcd.setCursor(0,2);for(i=0;i<14;i++){lcd.write(1);}
 
  lcd.setCursor(0,3);
  lcd.print("Te~;.;.");if(t1>=0){lcd.print(" ");}if(t1>0&&t1<10||t1<0&&t1>-10){lcd.print(" ");}lcd.print(t1,1); lcd.write(0);lcd.print("C");
  lcd.setCursor(0,4);
 
  lcd.print("Te~;.@.");if(t2>=0){lcd.print(" ");}if(t2>0&&t2<10||t2<0&&t2>-10){lcd.print(" ");}lcd.print(t2,1); lcd.write(0);lcd.print("C");
  lcd.setCursor(0,5);
  lcd.print("P ");lcd.print(p,1); // давление
  lcd.print(" H "); lcd.print(dht.readHumidity(),0);lcd.print(" %");// влажность
 
 
}
