#include <Wire.h>
#include <TDA7439.h>
#include <LiquidCrystal.h>
#include <EEPROMex.h>
#include <Encoder.h>
#include <MsTimer2.h>
#include <boarddefs.h>
#include <IRremote.h>
  IRrecv irrecv(10); // указываем вывод модуля IR приемника
  TDA7439 tda;
  Encoder myEnc(9, 8);//CLK, DT
  decode_results ir;
  LiquidCrystal lcd(7, 6, 2, 3, 4, 5);// RS,E,D4,D5,D6,D7
   byte a1[8]={0b00000,0b10101,0b10101,0b10101,0b10101,0b10101,0b10101,0b00000};
   byte a2[8]={0b00000,0b10100,0b10100,0b10100,0b10100,0b10100,0b10100,0b00000};
   byte a3[8]={0b00000,0b10000,0b10000,0b10000,0b10000,0b10000,0b10000,0b00000};
  int vol,vol_d,treb,treb_d,balans,in,gain,gain0,gain1,gain2,gain3,gain_d;
  byte w,w1,in_d,gr1,gr2,www;
  int z,z0,z1,bass,bass_d,mids,mids_d,menu,w2;
  unsigned long time,time1,time3,time4;long oldPosition  = -999,newPosition;
 
 void setup() { Serial.begin(9600); Serial.println("TDA7439");
  lcd.begin(16, 2);
  irrecv.enableIRIn(); // запускаем модуль IR
  lcd.setCursor(0,0);lcd.print("    TDA7439    ");delay(1000);
   pinMode(12,INPUT);// меню кнопка энкодера SW
   pinMode(11,INPUT);// in 1-4
  MsTimer2::set(3, to_Timer);MsTimer2::start();
  lcd.createChar(0,a1);lcd.createChar(1,a2);lcd.createChar(2,a3);
  vol = EEPROM.read(0);// vol eeprom 
  bass = EEPROM.read(1)-7;// bass eeprom
  mids = EEPROM.read(2)-7;// mids eeprom
  treb = EEPROM.read(3)-7;// treb eeprom
  balans = EEPROM.read(4)-4;// balans eeprom
  in = EEPROM.read(5);// in eeprom
  gain0 = EEPROM.read(6);// gain1 eeprom
  gain1 = EEPROM.read(7);// gain2 eeprom
  gain2 = EEPROM.read(8);// gain3 eeprom
  gain3 = EEPROM.read(9);// gain4 eeprom
  delay(500);audio();
 }
 
 void to_Timer(){newPosition = myEnc.read()/4;}
 
 void loop() { delay(10);
   if ( irrecv.decode( &ir )) {Serial.print("0x");Serial.println( ir.value,HEX);time1=millis();time=millis();w=1;w1=1;irrecv.resume();}// IR приемник
   if(digitalRead(12)==LOW){menu++;cl();myEnc.write(0);time=millis();w=1;w2=1;if(menu>4){menu=0;}}// меню
   if(digitalRead(11)==HIGH){in++;;cl();myEnc.write(0);time=millis();w=1;w2=1;www=1;menu=5;if(in>3){in=0;};audio();}// in
 
     if(ir.value==0x2FDD02F){menu++;gr1=0;gr2=0;cl();time=millis();w=1;w2=1;if(menu>4){menu=0;}}// меню кнопка вверх
     if(ir.value==0x2FD32CD){menu--;gr1=0;gr2=0;cl();time=millis();w=1;w2=1;if(menu<0){menu=4;}}// меню кнопка вниз
  
  // индикация громкости + управление  //////////////
   if(menu==0){ 
     if(millis()-time3>100){
     if(ir.value==0x2FD906F){vol++;gr1=1;gr2=0;cl1();w2=1;if(vol<0){vol=0;}if(vol>48){vol=48;}audio();}// кнопка > 
     if(ir.value==0xFFFFFFFF and gr1==1){vol++;gr2=0;cl1();w2=1;if(vol<0){vol=0;}if(vol>48){vol=48;}audio();}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){vol--;gr1=0;gr2=1;cl1();w2=1;if(vol<0){vol=0;}if(vol>48){vol=48;}audio();}// кнопка <
     if(ir.value==0xFFFFFFFF and gr2==1){vol--;gr1=0;cl1();w2=1;if(vol<0){vol=0;}if(vol>48){vol=48;}audio();}// кнопка <<<<<<
     }
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    vol=vol+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;w2=1;if(vol<0){vol=0;}if(vol>48){vol=48;}audio();} 
 lcd.setCursor(0,0);lcd.print("Volume  ");
  lcd.print(" ");lcd.print(-48+vol);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");vol_d=vol;
   if(w2==1){
   for(z=0,z0=0,z1=0;z<=vol_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1,1);lcd.print("   ");}}
   if(z1==3){lcd.setCursor(z0,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0,1);lcd.write((uint8_t)2);}w2=0;}}
 
 // индикация тембр НЧ  //////////////
 
  if(menu==1){ 
     if(ir.value==0x2FD906F){bass++;gr1=1;gr2=0;cl1();w2=1;if(bass>7){bass=7;}if(bass<-7){bass=-7;}audio();}// кнопка > 
     if(ir.value==0xFFFFFFFF and gr1==1){bass++;gr2=0;cl1();w2=1;if(bass>7){bass=7;}if(bass<-7){bass=-7;}audio();}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){bass--;gr1=0;gr2=1;cl1();w2=1;if(bass>7){bass=7;}if(bass<-7){bass=-7;}audio();}// кнопка < 
     if(ir.value==0xFFFFFFFF and gr2==1){bass--;gr1=0;cl1();w2=1;if(bass>7){bass=7;}if(bass<-7){bass=-7;}audio();}// кнопка <<<<<<
   
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    bass=bass+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;w2=1;if(bass>7){bass=7;}if(bass<-7){bass=-7;}audio();} 
   lcd.setCursor(0,0);lcd.print("Bass    ");
   lcd.print(" ");lcd.print(bass*2);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");bass_d=bass*2+15;
   if(w2==1){
   for(z=0,z0=0,z1=0;z<=bass_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("   ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}w2=0;}}
   
 // индикация тембр CЧ  //////////////  
 
   if(menu==2){ 
     if(ir.value==0x2FD906F){mids++;gr1=1;gr2=0;cl1();w2=1;if(mids>7){mids=7;}if(mids<-7){mids=-7;}audio();}// кнопка > 
     if(ir.value==0xFFFFFFFF and gr1==1){mids++;gr2=0;cl1();w2=1;if(mids>7){mids=7;}if(mids<-7){mids=-7;}audio();}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){mids--;gr1=0;gr2=1;cl1();w2=1;if(mids>7){mids=7;}if(mids<-7){mids=-7;}audio();}// кнопка < 
     if(ir.value==0xFFFFFFFF and gr2==1){mids--;gr1=0;cl1();w2=1;if(mids>7){mids=7;}if(mids<-7){mids=-7;}audio();}// кнопка <<<<<<
   
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    mids=mids+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;w2=1;if(mids>7){mids=7;}if(mids<-7){mids=-7;}audio();} 
   lcd.setCursor(0,0);lcd.print("Middle  ");
   lcd.print(" ");lcd.print(mids*2);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");mids_d=mids*2+15;
   if(w2==1){
   for(z=0,z0=0,z1=0;z<=mids_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("   ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}w2=0;}}
   
  // индикация тембр BЧ  //////////////
  if(menu==3){ 
     if(ir.value==0x2FD906F){treb++;gr1=1;gr2=0;cl1();w2=1;if(treb>7){treb=7;}if(treb<-7){treb=-7;}audio();}// кнопка > 
     if(ir.value==0xFFFFFFFF and gr1==1){treb++;gr2=0;cl1();w2=1;if(treb>7){treb=7;}if(treb<-7){treb=-7;}audio();}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){treb--;gr1=0;gr2=1;cl1();w2=1;if(treb>7){treb=7;}if(treb<-7){treb=-7;}audio();}// кнопка < 
     if(ir.value==0xFFFFFFFF and gr2==1){treb--;gr1=0;cl1();w2=1;if(treb>7){treb=7;}if(treb<-7){treb=-7;}audio();}// кнопка <<<<<<
   
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    treb=treb+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;w2=1;if(treb>7){treb=7;}if(treb<-7){treb=-7;}audio();} 
   lcd.setCursor(0,0);lcd.print("Treble  ");
   lcd.print(" ");lcd.print(treb*2);lcd.print(" ");lcd.setCursor(13,0);lcd.print("dB");treb_d=treb*2+15;
   if(w2==1){
   for(z=0,z0=0,z1=0;z<=treb_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0+3,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1+3,1);lcd.print("   ");}}
   if(z1==3){lcd.setCursor(z0+3,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0+3,1);lcd.write((uint8_t)2);}w2=0;}}
 
 ///////////////////////////////////////////////////////////
 
  // индикация баланс + управление кнопками +\- 4 дБ ///////
   if(menu==4){
     if(ir.value==0x2FD906F){balans++;gr1=1;gr2=0;cl();if(balans>4){balans=4;}if(balans<-4){balans=-4;}audio();}// кнопка > 
     if(ir.value==0xFFFFFFFF and gr1==1){balans++;gr2=0;cl();if(balans>4){balans=4;}if(balans<-4){balans=-4;}audio();}// кнопка >>>>>>
     if(ir.value==0x2FDF20D){balans--;gr1=0;gr2=1;cl();if(balans>4){balans=4;}if(balans<-4){balans=-4;}audio();}// кнопка < 
     if(ir.value==0xFFFFFFFF and gr2==1){balans--;gr1=0;cl();if(balans>4){balans=4;}if(balans<-4){balans=-4;}audio();}// кнопка <<<<<<
 
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    balans=balans+newPosition;myEnc.write(0);newPosition=0;lcd.clear();time=millis();w=1;if(balans>4){balans=4;}if(balans<-4){balans=-4;}audio();}
  lcd.setCursor(0,0);
   if(balans>=0){lcd.print("-");}else{lcd.print("+");}
  lcd.print(abs(balans));lcd.print(" dB ");
  lcd.print(" <>  ");
   if(balans>=0){lcd.print("+");}else{lcd.print("-");}
  lcd.print(abs(balans));lcd.print(" dB ");
  lcd.setCursor(0,1);lcd.print("L");
  lcd.setCursor(15,1);lcd.print("R");
   if(balans<0){lcd.setCursor(balans+7,1);lcd.write((uint8_t)0);}
   if(balans>0){lcd.setCursor(balans+8,1);lcd.write((uint8_t)0);}
   if(balans==0){lcd.setCursor(7,1);lcd.write((uint8_t)0);lcd.setCursor(8,1);lcd.write((uint8_t)0);}
 }
 
   if(menu==5){
        switch(in){
     case 0: gain = gain0;break;
     case 1: gain = gain1;break;
     case 2: gain = gain2;break;
     case 3: gain = gain3;break;
     }
    if (newPosition != oldPosition) {
    oldPosition = newPosition;
    gain=gain+newPosition;myEnc.write(0);newPosition=0;time=millis();w=1;w2=1;if(gain<0){gain=0;}if(gain>15){gain=15;}audio();} 
   switch(in){
     case 0: gain0 = gain;break;
     case 1: gain1 = gain;break;
     case 2: gain2 = gain;break;
     case 3: gain3 = gain;break;
     } 
     if(www==1){audio();www=0;}
   lcd.setCursor(0,0);lcd.print("Gain IN ");lcd.print(in);
      lcd.setCursor(10,0);lcd.print(" ");lcd.print(gain*2);lcd.print(" ");lcd.setCursor(14,0);lcd.print("dB");gain_d=gain;
   if(w2==1){
   for(z=0,z0=0,z1=0;z<=gain_d;z++,z1++){if(z1>2){z1=0;z0++;}
   if(z1==1){lcd.setCursor(z0,1);lcd.write((uint8_t)0);lcd.setCursor(z0+1,1);lcd.print("   ");}}
   if(z1==3){lcd.setCursor(z0,1);lcd.write((uint8_t)1);}
   if(z1==2){lcd.setCursor(z0,1);lcd.write((uint8_t)2);}}w2=0;
  }
 /////////////////////////////////////////////////////////////
 


   if(millis()-time>5000 && w==1){// запись всех настроек в EEPROM через 60 сек неактивности
     EEPROM.update(0,vol);
     EEPROM.update(4,balans+4);
     EEPROM.update(1,bass+7);
     EEPROM.update(2,mids+7);
     EEPROM.update(3,treb+7);
     EEPROM.update(5,in);
     EEPROM.update(6,gain0);EEPROM.update(7,gain1);EEPROM.update(8,gain2);EEPROM.update(9,gain3);lcd.clear();w=0,w2=1;menu=0;
 }
 }//void
 
 void cl(){ir.value=0;delay(300);lcd.clear();}
 void cl1(){ir.value=0;delay(50);}
 void audio(){
  tda.setInput(in+1); // 1 to 4 // номер канала
  tda.inputGain(gain); // 0 to 15 // усиление 
  tda.setVolume(vol); // 0 to 48 ( 0 is mute) // громкость
  tda.setSnd(bass, 1); //-7 to +7 , 1 - Bass | 2 - Mids | 3 - Trebble
  tda.setSnd(mids, 2);
  tda.setSnd(treb, 3); 
  tda.spkAtt(4-balans, 4+balans); // баланс R L от 0 to 79 (db) 
 }
