//************************************************************************************
//**  
//**  File name:     C:\c_mert\Comparator.c
//**  Title:         
//**  Description:   
//**  
//**  Generated by:  Flowcode v5.2.0.0
//**  Date:          Thursday, January 25, 2018 09:15:22
//**  Licence:       Professional
//**  Registered to: xyz
//**  Licence key:   WUK7B9
//**  
//**  
//**  http://www.matrixmultimedia.com
//**  
//************************************************************************************


#define MX_PIC

#define MX_USES_UINT8 1
#define MX_USES_SINT16 1
#define MX_USES_CHAR 0
#define MX_USES_FLOAT 0
#define MX_USES_SINT32 0
#define MX_USES_BOOL 1
#define MX_USES_UINT16 1
#define MX_USES_UINT32 1
//Defines for microcontroller
#define P16F628A
#define FC_CAL_PIC
#define MX_EE
#define MX_EE_SIZE 128
#define MX_UART_1
#define MX_UART_1_TX_PORT portb
#define MX_UART_1_TX_TRIS trisb
#define MX_UART_1_TX_PIN 2
#define MX_UART_1_RX_PORT portb
#define MX_UART_1_RX_TRIS trisb
#define MX_UART_1_RX_PIN 1
#define MX_PWM
#define MX_PWM_CNT 1
#define MX_PWM_PSCA1
#define MX_PWM_PSCA4
#define MX_PWM_PSCA16
#define MX_PWM_1_PORT portb
#define MX_PWM_1_TRIS trisb
#define MX_PWM_1_PIN 3

//Functions
#define MX_CLK_SPEED 10000000
#ifdef _BOOSTC
#include <system.h>
#endif
#ifdef HI_TECH_C
#include <pic.h>
#endif

//Configuration data
#ifdef _BOOSTC
#pragma DATA 0x2007, 0x3f0a
#endif
#ifdef HI_TECH_C
__CONFIG(0x3f0a);
#endif

//?????????? ???????
#include "C:\Program Files\Flowcode\v5\FCD\internals.c"

//Macro function declarations
void FCM_comparator();
void FCM_time();
void FCM_kn();


//Variable declarations
MX_BOOL FCV_U;
MX_UINT32 FCV_BB;
MX_UINT32 FCV_REZ;
MX_BOOL FCV_LOGIK;
MX_BOOL FCV_KN;
MX_UINT32 FCV_X;
MX_BOOL FCV_N0;
MX_UINT8 FCV_N1;
MX_UINT8 FCV_SH;
MX_BOOL FCV_PER;
MX_BOOL FCV_KN1;
MX_UINT32 FCV_REZ0;
MX_SINT16 FCV_A;
MX_UINT16 FCV_B;
MX_UINT32 FCV_CCC;
MX_UINT8 FCV_C1;
MX_UINT16 FCV_T;
MX_BOOL FCV_TOHKA;




//LCDDisplay(0): //Defines:

/**** Macro Substitutions ****
a = Unique Component Reference Number
b = D1 Port Letter
c = D2 Port Letter
d = D3 Port Letter
e = D4 Port Letter
f = RS Port Letter
g = E Port Letter
h = Data 1_Pin
i = Data 2 Pin
j = Data 3 Pin
k = Data 4 Pin
l = RS Pin
m = Enable Pin
n = Row Count
o = Column Count
******************************/

	//component connections
	#define LCD_8__PORT0    portb
	#define LCD_8__PORT1    portb
	#define LCD_8__PORT2    portb
	#define LCD_8__PORT3    portb
	#define LCD_8__PORT4    portb
	#define LCD_8__PORT5    portb
	#define LCD_8__TRIS0    trisb
	#define LCD_8__TRIS1    trisb
	#define LCD_8__TRIS2    trisb
	#define LCD_8__TRIS3    trisb
	#define LCD_8__TRIS4    trisb
	#define LCD_8__TRIS5    trisb
	#define LCD_8__BIT0    	0
	#define LCD_8__BIT1    	1
	#define LCD_8__BIT2    	2
	#define LCD_8__BIT3    	3
	#define LCD_8__RS      	4
	#define LCD_8__E       	5
	#define LCD_8__ROWCNT	2
	#define LCD_8__COLCNT	16

	#ifdef _BOOSTC
	  #define LCD_8__DELAY   delay_10us(10)
	#endif
	#ifdef _C2C_
	  #define LCD_8__DELAY   delay_us(100)
	#endif
	#ifdef HI_TECH_C
	  #define LCD_8__DELAY   __delay_us(120)
	#endif
	#ifndef LCD_8__DELAY
	  #define LCD_8__DELAY   delay_us(100)
	#endif




//LCDDisplay(0): //Macro function declarations

void FCD_LCDDisplay0_RawSend(MX_UINT8 in, MX_UINT8 mask);
void FCD_LCDDisplay0_Start();
void FCD_LCDDisplay0_Clear();
void FCD_LCDDisplay0_PrintASCII(MX_UINT8 Character);
void FCD_LCDDisplay0_Command(MX_UINT8 in);
void FCD_LCDDisplay0_Cursor(MX_UINT8 x, MX_UINT8 y);
void FCD_LCDDisplay0_PrintNumber(MX_SINT16 Number);
void FCD_LCDDisplay0_PrintString(MX_STRING String, MX_UINT8 MSZ_String);
void FCD_LCDDisplay0_ScrollDisplay(MX_UINT8 Direction, MX_UINT8 Num_Positions);
void FCD_LCDDisplay0_ClearLine(MX_UINT8 Line);
void FCD_LCDDisplay0_RAM_Write(MX_UINT8 nIdx, MX_UINT8 d0, MX_UINT8 d1, MX_UINT8 d2, MX_UINT8 d3, MX_UINT8 d4, MX_UINT8 d5, MX_UINT8 d6, MX_UINT8 d7);


//SWITCH(0): //Defines:

/**** Macro Substitutions ****
a = Unique Reference
b = Switch Port Letter
c = Switch Pin Number
d = Switch Polarity Control
e = Switch Debounce Delay Value (us)
******************************/

#define Switch_9_SW_PORT		porta
#define Switch_9_SW_TRIS		trisa
#define Switch_9_SW_PIN		4
#define Switch_9_SW_POLE		1 - 0

//Work out a schema for debounce delays
#define Switch_9_SW_DELAY		0 * 90					//90% + overhead
#define Switch_9_SW_DEL		delay_us(10)

#if (Switch_9_SW_DELAY > 65535)
	#undef Switch_9_SW_DELAY
	#undef Switch_9_SW_DEL
	#define Switch_9_SW_DELAY		0 * 9				//90% + overhead
	#define Switch_9_SW_DEL		delay_us(100)
	#if (Switch_9_SW_DELAY > 65535)
		#undef Switch_9_SW_DELAY
		#undef Switch_9_SW_DEL
		#define Switch_9_SW_DELAY		0
		#define Switch_9_SW_DEL		delay_ms(1)
		#if (Switch_9_SW_DELAY > 65535)
			#error "Switch Switch_9 Debounce Delay Too Large."
		#endif
	#endif
#endif




//SWITCH(0): //Macro function declarations

MX_UINT8 FCD_SWITCH0_ReadState();
void FCD_SWITCH0_WaitUntilHigh();
void FCD_SWITCH0_WaitUntilLow();



//LCDDisplay(0): //Macro implementations


void FCD_LCDDisplay0_RawSend(MX_UINT8 in, MX_UINT8 mask)
{
	
		MX_UINT8 pt;

		FC_CAL_Bit_Low(LCD_8__PORT0, LCD_8__BIT0);
		FC_CAL_Bit_Low(LCD_8__PORT1, LCD_8__BIT1);
		FC_CAL_Bit_Low(LCD_8__PORT2, LCD_8__BIT2);
		FC_CAL_Bit_Low(LCD_8__PORT3, LCD_8__BIT3);
		FC_CAL_Bit_Low(LCD_8__PORT4, LCD_8__RS);
		FC_CAL_Bit_Low(LCD_8__PORT5, LCD_8__E);
		pt = ((in >> 4) & 0x0f);
		if (pt & 0x01)
		    FC_CAL_Bit_High(LCD_8__PORT0, LCD_8__BIT0);
		if (pt & 0x02)
		    FC_CAL_Bit_High(LCD_8__PORT1, LCD_8__BIT1);
		if (pt & 0x04)
		    FC_CAL_Bit_High(LCD_8__PORT2, LCD_8__BIT2);
		if (pt & 0x08)
		    FC_CAL_Bit_High(LCD_8__PORT3, LCD_8__BIT3);
		if (mask)
		    FC_CAL_Bit_High(LCD_8__PORT4, LCD_8__RS);
		LCD_8__DELAY;
		FC_CAL_Bit_High (LCD_8__PORT5, LCD_8__E);
		LCD_8__DELAY;
		FC_CAL_Bit_Low (LCD_8__PORT5, LCD_8__E);
		pt = (in & 0x0f);
		LCD_8__DELAY;
		FC_CAL_Bit_Low(LCD_8__PORT0, LCD_8__BIT0);
		FC_CAL_Bit_Low(LCD_8__PORT1, LCD_8__BIT1);
		FC_CAL_Bit_Low(LCD_8__PORT2, LCD_8__BIT2);
		FC_CAL_Bit_Low(LCD_8__PORT3, LCD_8__BIT3);
		FC_CAL_Bit_Low(LCD_8__PORT4, LCD_8__RS);
		FC_CAL_Bit_Low(LCD_8__PORT5, LCD_8__E);
		if (pt & 0x01)
		    FC_CAL_Bit_High(LCD_8__PORT0, LCD_8__BIT0);
		if (pt & 0x02)
		    FC_CAL_Bit_High(LCD_8__PORT1, LCD_8__BIT1);
		if (pt & 0x04)
		    FC_CAL_Bit_High(LCD_8__PORT2, LCD_8__BIT2);
		if (pt & 0x08)
		    FC_CAL_Bit_High(LCD_8__PORT3, LCD_8__BIT3);
		if (mask)
		    FC_CAL_Bit_High(LCD_8__PORT4, LCD_8__RS);
		LCD_8__DELAY;
		FC_CAL_Bit_High (LCD_8__PORT5, LCD_8__E);
		LCD_8__DELAY;
		FC_CAL_Bit_Low (LCD_8__PORT5, LCD_8__E);
		LCD_8__DELAY;

}

void FCD_LCDDisplay0_Start()
{
	
		FC_CAL_Bit_Low_DDR(LCD_8__PORT0, LCD_8__TRIS0, LCD_8__BIT0);
		FC_CAL_Bit_Low_DDR(LCD_8__PORT1, LCD_8__TRIS1, LCD_8__BIT1);
		FC_CAL_Bit_Low_DDR(LCD_8__PORT2, LCD_8__TRIS2, LCD_8__BIT2);
		FC_CAL_Bit_Low_DDR(LCD_8__PORT3, LCD_8__TRIS3, LCD_8__BIT3);
		FC_CAL_Bit_Low_DDR(LCD_8__PORT4, LCD_8__TRIS4, LCD_8__RS);
		FC_CAL_Bit_Low_DDR(LCD_8__PORT5, LCD_8__TRIS5, LCD_8__E);

		Wdt_Delay_Ms(12);

		FCD_LCDDisplay0_RawSend(0x33, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x33, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x32, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x2c, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x06, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x0c, 0);
		Wdt_Delay_Ms(2);

		//clear the display
		FCD_LCDDisplay0_RawSend(0x01, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x02, 0);
		Wdt_Delay_Ms(2);

}

void FCD_LCDDisplay0_Clear()
{
	
		FCD_LCDDisplay0_RawSend(0x01, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x02, 0);
		Wdt_Delay_Ms(2);

}

void FCD_LCDDisplay0_PrintASCII(MX_UINT8 Character)
{
	
		FCD_LCDDisplay0_RawSend(Character, 0x10);

}

void FCD_LCDDisplay0_Command(MX_UINT8 in)
{
	
		FCD_LCDDisplay0_RawSend(in, 0);
		Wdt_Delay_Ms(2);

}

void FCD_LCDDisplay0_Cursor(MX_UINT8 x, MX_UINT8 y)
{
	
	  #if (LCD_8__ROWCNT == 1)
	    y=0x80;
	  #endif

	  #if (LCD_8__ROWCNT == 2)
		if (y==0)
			y=0x80;
		else
			y=0xc0;
	  #endif

	  #if (LCD_8__ROWCNT == 4)
		if (y==0)
			y=0x80;
		else if (y==1)
			y=0xc0;

		#if (LCD_8__COLCNT == 16)
			else if (y==2)
				y=0x90;
			else
				y=0xd0;
		#endif

		#if (LCD_8__COLCNT == 20)
			else if (y==2)
				y=0x94;
			else
				y=0xd4;
		#endif
	  #endif

		FCD_LCDDisplay0_RawSend(y+x, 0);
		Wdt_Delay_Ms(2);

}

void FCD_LCDDisplay0_PrintNumber(MX_SINT16 Number)
{
	
		MX_SINT16 tmp_int;
		MX_UINT8 tmp_byte;

		if (Number < 0)
		{
			FCD_LCDDisplay0_RawSend('-', 0x10);
			Number = 0 - Number;
		}

		tmp_int = Number;
		if (Number >= 10000)
		{
			tmp_byte = tmp_int / 10000;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 10000;
				tmp_byte--;
			}
		}
		if (Number >= 1000)
		{
			tmp_byte = tmp_int / 1000;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 1000;
				tmp_byte--;
			}
		}
		if (Number >= 100)
		{
			tmp_byte = tmp_int / 100;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 100;
				tmp_byte--;
			}
		}
		if (Number >= 10)
		{
			tmp_byte = tmp_int / 10;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 10;
				tmp_byte--;
			}
		}
		FCD_LCDDisplay0_RawSend('0' + tmp_int, 0x10);

}

void FCD_LCDDisplay0_PrintString(MX_STRING String, MX_UINT8 MSZ_String)
{
	
		MX_UINT8 idx = 0;

		for (idx=0; idx<MSZ_String; idx++)
		{
			if (String[idx] == 0)
			{
				break;
			}
			FCD_LCDDisplay0_RawSend(String[idx], 0x10);
		}

}

void FCD_LCDDisplay0_ScrollDisplay(MX_UINT8 Direction, MX_UINT8 Num_Positions)
{
	
		MX_UINT8 cmd = 0;
		MX_UINT8 count;

		//Choose the direction
		switch (Direction)
		{
			case 0:
			case 'l':
			case 'L':

				cmd = 0x18;
				break;

			case 1:
			case 'r':
			case 'R':

				cmd = 0x1C;
				break;

			default:
				break;
		}

		//If direction accepted then scroll the specified amount
		if (cmd)
		{
			for (count = 0; count < Num_Positions; count++)
				FCD_LCDDisplay0_Command(cmd);
		}

}

void FCD_LCDDisplay0_ClearLine(MX_UINT8 Line)
{
	
		MX_UINT8 count;
		MX_UINT8 rowcount;

		//Define number of columns per line
		#if (LCD_8__ROWCNT == 1)
			rowcount=80;
		#endif

		#if (LCD_8__ROWCNT == 2)
			rowcount=40;
		#endif

		#if (LCD_8__ROWCNT == 4)
			#if (LCD_8__COLCNT == 16)
				rowcount=16;
			#endif
			#if (LCD_8__COLCNT == 20)
				rowcount=20;
			#endif
		#endif

		//Start at beginning of the line
		FCD_LCDDisplay0_Cursor (0, Line);

		//Send out spaces to clear line
		for (count = 0; count < rowcount; count++)
			FCD_LCDDisplay0_RawSend(' ', 0x10);

		//Move back to the beginning of the line.
		FCD_LCDDisplay0_Cursor (0, Line);

}

void FCD_LCDDisplay0_RAM_Write(MX_UINT8 nIdx, MX_UINT8 d0, MX_UINT8 d1, MX_UINT8 d2, MX_UINT8 d3, MX_UINT8 d4, MX_UINT8 d5, MX_UINT8 d6, MX_UINT8 d7)
{
	   //set CGRAM address

	   FCD_LCDDisplay0_RawSend(64 + (nIdx << 3), 0);
	   delay_ms(2);

	   //write CGRAM data
	   FCD_LCDDisplay0_RawSend(d0, 0x10);
	   FCD_LCDDisplay0_RawSend(d1, 0x10);
	   FCD_LCDDisplay0_RawSend(d2, 0x10);
	   FCD_LCDDisplay0_RawSend(d3, 0x10);
	   FCD_LCDDisplay0_RawSend(d4, 0x10);
	   FCD_LCDDisplay0_RawSend(d5, 0x10);
	   FCD_LCDDisplay0_RawSend(d6, 0x10);
	   FCD_LCDDisplay0_RawSend(d7, 0x10);

	   //Clear the display
	   FCD_LCDDisplay0_RawSend(0x01, 0);
	   delay_ms(2);
	   FCD_LCDDisplay0_RawSend(0x02, 0);
	   delay_ms(2);

}



//SWITCH(0): //Macro implementations


MX_UINT8 FCD_SWITCH0_ReadState()
{
	
		MX_UINT8 switchval = 255;

	  #if Switch_9_SW_DELAY > 0
		MX_UINT16 del_count;
		MX_UINT8 old_switchval;
	  #endif

		FC_CAL_Bit_In_DDR( Switch_9_SW_PORT , Switch_9_SW_TRIS , Switch_9_SW_PIN );		//Convert pin to input
		switchval = FC_CAL_Bit_In( Switch_9_SW_PORT , Switch_9_SW_PIN );			//Sample input

	  #if (Switch_9_SW_POLE == 0)
		if (switchval)													//Invert logic if required
			switchval = 0;
		else
			switchval = 1;
	  #endif

	  #if (Switch_9_SW_DELAY > 0)

		del_count = 0;
		old_switchval = 255;

		while (del_count < Switch_9_SW_DELAY)									//Debounce input
		{
			Switch_9_SW_DEL;
			switchval = FC_CAL_Bit_In( Switch_9_SW_PORT , Switch_9_SW_PIN );		//Sample input

		  #if (Switch_9_SW_POLE == 0)
			if (switchval)												//Invert logic if required
				switchval = 0;
			else
				switchval = 1;
		  #endif

			if (switchval == old_switchval)								//Is switch the same state?
				del_count++;											//Increment counter
			else
				del_count = 0;											//Else reset counter

			old_switchval = switchval;									//Update the old state
		}
	  #endif

		return (switchval);												//Return state of switch as least significant bit

}

void FCD_SWITCH0_WaitUntilHigh()
{
	
		MX_UINT8 switchval = 255;

	  #if Switch_9_SW_DELAY > 0
		MX_UINT16 del_count;
		MX_UINT8 old_switchval;
	  #endif

		FC_CAL_Bit_In_DDR ( Switch_9_SW_PORT , Switch_9_SW_TRIS , Switch_9_SW_PIN );

		while (switchval != Switch_9_SW_POLE)										//While state not active
		{
			switchval = FC_CAL_Bit_In ( Switch_9_SW_PORT, Switch_9_SW_PIN );			//Convert pin to input

		  #if (Switch_9_SW_DELAY > 0)

		  	del_count = 0;
		  	old_switchval = 255;

			while (del_count < Switch_9_SW_DELAY)									//Debounce input
			{
				Switch_9_SW_DEL;
				switchval = FC_CAL_Bit_In ( Switch_9_SW_PORT , Switch_9_SW_PIN );		//Sample input

				if (switchval == old_switchval)								//Is switch the same state?
					del_count++;											//Increment counter
				else
					del_count = 0;											//Else reset counter

				old_switchval = switchval;									//Update the old state
			}
		  #endif
		}

}

void FCD_SWITCH0_WaitUntilLow()
{
	
		MX_UINT8 switchval = Switch_9_SW_POLE;

	  #if Switch_9_SW_DELAY > 0
		MX_UINT16 del_count = 0;
		MX_UINT8 old_switchval;
	  #endif

		FC_CAL_Bit_In_DDR ( Switch_9_SW_PORT, Switch_9_SW_TRIS , Switch_9_SW_PIN );			//Convert pin to input

		while (switchval == Switch_9_SW_POLE)										//While state active
		{
			switchval = FC_CAL_Bit_In ( Switch_9_SW_PORT, Switch_9_SW_PIN );			//Sample input

		  #if (Switch_9_SW_DELAY > 0)

		  	del_count = 0;
		  	old_switchval = 255;

			while (del_count < Switch_9_SW_DELAY)									//Debounce input
			{
				Switch_9_SW_DEL;
				switchval = FC_CAL_Bit_In ( Switch_9_SW_PORT, Switch_9_SW_PIN );		//Sample input

				if (switchval == old_switchval)								//Is switch the same state?
					del_count++;											//Increment counter
				else
					del_count = 0;											//Else reset counter

				old_switchval = switchval;									//Update the old state
			}
		  #endif
		}

}

#include "C:\Program Files\Flowcode\v5\CAL\includes.c"

//Macro implementations


void FCM_comparator()
{

	//C Code
	//C ???:
	FCV_C1 = ts_bit(cmcon, C1OUT); 

}


void FCM_time()
{

	//??????????
	//??????????:
	//  a = a + 1
	//  t = 1
	FCV_A = FCV_A + 1;
	FCV_T = 1;

	//???????
	//???????: a = 31250?
	if (FCV_A == 31250)
	{

		//??????????
		//??????????:
		//  a = 0
		//  b = b + 1
		FCV_A = 0;
		FCV_B = FCV_B + 1;

	// } else {

	}

	//???????
	//???????: C1 = 0?
	if (FCV_C1 == 0)
	{

		//??????????
		//??????????:
		//  t = 0
		FCV_T = 0;

		//??????????
		//??????????: ????????? TMR2
		cr_bit(pie1, TMR2IE);

	// } else {

	}

}


void FCM_kn()
{

	//?????? ??????????
	//?????? ??????????: kn=?????? ?????????()
	FCV_KN = FCD_SWITCH0_ReadState();

	//???????
	//???????: kn = 1?
	if (FCV_KN == 1)
	{

		//????????
		//????????: 200 ms
		delay_ms(200);

		//??????????
		//??????????:
		//  sh = 1
		FCV_SH = 1;

		//??????????
		//??????????:
		//  a = 0
		//  b = 0
		//  per = 0
		FCV_A = 0;
		FCV_B = 0;
		FCV_PER = 0;

	// } else {

	}

}



void main()
{
	//Initialization
	cmcon = 0x07;


	//Interrupt initialization code
	option_reg = 0xC0;


	//?????? ??????????
	//?????? ??????????: ??????()
	FCD_LCDDisplay0_Start();

	//??????????
	//??????????:
	//  rez = 0
	//  rez0 = 0
	FCV_REZ = 0;
	FCV_REZ0 = 0;

	//C Code
	//C ???:
	trisa = 0x07;
	cmcon = 0x06; 
	vrcon = 0xEF; 

	//Interrupt
	//??????????: ????????? COMP_INT
	st_bit(intcon,GIE);
	cr_bit(pir1, CMIF);    // ??????? ???? CMIF ???????? pir1 (???? ?????????? ? ????)
	st_bit(pie1, CMIE);    // ????????? ???? CMIE ???????? pie1 (?????????? ?????????? ???????????) 
	st_bit(intcon, PEIE);  // ????????? ???? PEIE ???????? intcon (?????????? ?????????? ?????????)
	st_bit(intcon, GIE);   // ????????? ???? GIE ???????? intcon (?????????? ?????????? ??????????)

	//Loop
	//????: While 1
	while (1)
	{

		//?????
		//?????: kn()
		FCM_kn();

		//???????
		//???????: sh = 1?
		if (FCV_SH == 1)
		{

			//??????????
			//??????????: ????????? TMR2
			st_bit(intcon,PEIE);
			cr_bit(t2con,T2CKPS0);
			cr_bit(t2con,T2CKPS1);
			st_bit(t2con,TMR2ON);
			t2con = (t2con & 0x07) | 0x20;
			pr2=16-1;
			st_bit(intcon,GIE);
			st_bit(pie1, TMR2IE);

			//???????
			//???????: per = 0?
			if (FCV_PER == 0)
			{

				//???????????:
				//?????? ??? per = 0

				//????
				//????: B6 -> u
				trisb = trisb | 0x40;
				FCV_U = ((portb & 0x40) == 0x40);

				//?????
				//?????: 1 -> B7
				trisb = trisb & 0x7F;
				if ((1))
					portb = (portb & 0x7F) | 0x80;
				else
					portb = portb & 0x7F;

			} else {

				//????
				//????: B7 -> u
				trisb = trisb | 0x80;
				FCV_U = ((portb & 0x80) == 0x80);

				//?????
				//?????: 1 -> B6
				trisb = trisb & 0xBF;
				if ((1))
					portb = (portb & 0xBF) | 0x40;
				else
					portb = portb & 0xBF;

			}

		// } else {

		}

		//???????????:
		//????????? ?????

		//???????
		//???????: C1 = 0?
		if (FCV_C1 == 0)
		{

			//???????
			//???????: per = 0 AND a < 350 AND b = 0?
			if (FCV_PER == 0 & FCV_A < 350 & FCV_B == 0)
			{

				//??????????
				//??????????:
				//  per = 1
				//  sh = 1
				//  logik = 1
				FCV_PER = 1;
				FCV_SH = 1;
				FCV_LOGIK = 1;

				//??????????
				//??????????:
				//  a = 0
				//  b = 0
				FCV_A = 0;
				FCV_B = 0;

			// } else {

			}

			//???????
			//???????: per = 1?
			if (FCV_PER == 1)
			{

				//???????
				//???????: logik = 1?
				if (FCV_LOGIK == 1)
				{

					//?????
					//?????: 0 -> B6
					trisb = trisb & 0xBF;
					if ((0))
						portb = (portb & 0xBF) | 0x40;
					else
						portb = portb & 0xBF;

					//?????
					//?????: 0 -> B7
					trisb = trisb & 0x7F;
					if ((0))
						portb = (portb & 0x7F) | 0x80;
					else
						portb = portb & 0x7F;

					//????????
					//????????: 500 ms
					delay_ms(255);
					delay_ms(245);

					//??????????
					//??????????:
					//  logik = 0
					//  per = 1
					//  C1 = 1
					FCV_LOGIK = 0;
					FCV_PER = 1;
					FCV_C1 = 1;

				} else {

					//???????????:
					//??

					//?????
					//?????: 0 -> B6
					trisb = trisb & 0xBF;
					if ((0))
						portb = (portb & 0xBF) | 0x40;
					else
						portb = portb & 0xBF;

					//?????
					//?????: 0 -> B7
					trisb = trisb & 0x7F;
					if ((0))
						portb = (portb & 0x7F) | 0x80;
					else
						portb = portb & 0x7F;

					//????????
					//????????: 500 ms
					delay_ms(255);
					delay_ms(245);

					//????
					//????: B6 -> u
					trisb = trisb | 0x40;
					FCV_U = ((portb & 0x40) == 0x40);

					//??????????
					//??????????:
					//  sh = 0
					FCV_SH = 0;

					//??????????
					//??????????:
					//  bb = b * 31250
					//  x = a + bb
					//  ccc = (x * 9700 / 31250) - 1
					//  rez = ccc / 100
					//  rez0 = ccc - (rez * 100)
					//  tohka = 1
					FCV_BB = FCV_B * 31250;
					FCV_X = FCV_A + FCV_BB;
					FCV_CCC = (FCV_X * 9700 / 31250) - 1;
					FCV_REZ = FCV_CCC / 100;
					FCV_REZ0 = FCV_CCC - (FCV_REZ * 100);
					FCV_TOHKA = 1;

				}

			} else {

				//???????????:
				//???

				//?????
				//?????: 0 -> B7
				trisb = trisb & 0x7F;
				if ((0))
					portb = (portb & 0x7F) | 0x80;
				else
					portb = portb & 0x7F;

				//?????
				//?????: 0 -> B6
				trisb = trisb & 0xBF;
				if ((0))
					portb = (portb & 0xBF) | 0x40;
				else
					portb = portb & 0xBF;

				//????????
				//????????: 500 ms
				delay_ms(255);
				delay_ms(245);

				//????
				//????: B7 -> u
				trisb = trisb | 0x80;
				FCV_U = ((portb & 0x80) == 0x80);

				//??????????
				//??????????:
				//  sh = 0
				FCV_SH = 0;

				//??????????
				//??????????:
				//  bb = b * 31250
				//  x = (a + bb) / 10
				FCV_BB = FCV_B * 31250;
				FCV_X = (FCV_A + FCV_BB) / 10;

				//???????
				//???????: x >= 350000?
				if (FCV_X >= 350000)
				{

					//??????????
					//??????????:
					//  ccc = x * 970 / 3125
					//  rez = ccc / 10
					//  rez0 = ccc - (rez * 10)
					//  tohka = 0
					FCV_CCC = FCV_X * 970 / 3125;
					FCV_REZ = FCV_CCC / 10;
					FCV_REZ0 = FCV_CCC - (FCV_REZ * 10);
					FCV_TOHKA = 0;

				} else {

					//??????????
					//??????????:
					//  ccc = x * 9700 / 3125
					//  rez = ccc / 100
					//  rez0 = ccc - (rez * 100)
					//  tohka = 1
					FCV_CCC = FCV_X * 9700 / 3125;
					FCV_REZ = FCV_CCC / 100;
					FCV_REZ0 = FCV_CCC - (FCV_REZ * 100);
					FCV_TOHKA = 1;

				}

			}

		// } else {

		}

		//????????
		//????????: 100 ms
		delay_ms(100);

		//?????? ??????????
		//?????? ??????????: ??????(1, 0)
		FCD_LCDDisplay0_Cursor(1, 0);

		//?????? ??????????
		//?????? ??????????: ??????ASCII("C = ")
		FCD_LCDDisplay0_PrintASCII('C');
		FCD_LCDDisplay0_PrintASCII(' ');
		FCD_LCDDisplay0_PrintASCII('=');
		FCD_LCDDisplay0_PrintASCII(' ');

		//?????? ??????????
		//?????? ??????????: ??????Number(rez)
		FCD_LCDDisplay0_PrintNumber(FCV_REZ);

		//?????? ??????????
		//?????? ??????????: ??????ASCII(".")
		FCD_LCDDisplay0_PrintASCII('.');

		//???????
		//???????: rez0 < 10 AND tohka = 1?
		if (FCV_REZ0 < 10 & FCV_TOHKA == 1)
		{

			//?????? ??????????
			//?????? ??????????: ??????ASCII("0")
			FCD_LCDDisplay0_PrintASCII('0');

		// } else {

		}

		//???????
		//???????: rez0 < 100 AND rez0 > 10 AND tohka = 2?
		if (FCV_REZ0 < 100 & FCV_REZ0 > 10 & FCV_TOHKA == 2)
		{

			//?????? ??????????
			//?????? ??????????: ??????ASCII("0")
			FCD_LCDDisplay0_PrintASCII('0');

		// } else {

		}

		//?????? ??????????
		//?????? ??????????: ??????Number(rez0)
		FCD_LCDDisplay0_PrintNumber(FCV_REZ0);

		//???????
		//???????: per = 1?
		if (FCV_PER == 1)
		{

			//?????? ??????????
			//?????? ??????????: ??????ASCII(" nF     ")
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII('n');
			FCD_LCDDisplay0_PrintASCII('F');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');

		} else {

			//?????? ??????????
			//?????? ??????????: ??????ASCII(" uF     ")
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII('u');
			FCD_LCDDisplay0_PrintASCII('F');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');

		}

		//?????? ??????????
		//?????? ??????????: ??????(1, 1)
		FCD_LCDDisplay0_Cursor(1, 1);

		//???????
		//???????: t = 1?
		if (FCV_T == 1)
		{

			//?????? ??????????
			//?????? ??????????: ??????ASCII("     TEST     ")
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII('T');
			FCD_LCDDisplay0_PrintASCII('E');
			FCD_LCDDisplay0_PrintASCII('S');
			FCD_LCDDisplay0_PrintASCII('T');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');

		} else {

			//?????? ??????????
			//?????? ??????????: ??????ASCII("                ")
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');
			FCD_LCDDisplay0_PrintASCII(' ');

		}


	}

	mainendloop: goto mainendloop;
}

void MX_INTERRUPT_MACRO(void)
{
	//Handler code for [COMP_INT]
	if (pir1 & (1 << CMIF))       //???? ??????????? ???? ??????????
	{
	FCM_comparator();                     // ????????? ??????
	cr_bit(pir1, CMIF);           // ???????? ??? ????? ?????????? (? ????)
	}

	//Handler code for [TMR2]
	#ifndef MX_INTHANDLER_pir1_TMR2IF
	#define MX_INTHANDLER_pir1_TMR2IF
	if (ts_bit(pir1, TMR2IF) && ts_bit(pie1, TMR2IE))
	{
		#ifdef USE_FLOWCODE_ICD
			extern char ICD_Interrupt_Enable = 1;
		#endif	
		FCM_time();
		cr_bit(pir1, TMR2IF);
		#ifdef USE_FLOWCODE_ICD
			extern char ICD_Interrupt_Enable = 0;
		#endif	
	}
	#else
	#warning "This interrupt has previously been enabled, so the macro <time> may never get called."
	#endif


}



