<?php
/*
Plugin Name: Qip Smiles
Version: 1.0.1
Description: Add Qip smiles for your blog comments. Animated smilies made by <a href="http://www.kolobok.us/">Aiwan</a>. All images belong to their respective owners. 
Plugin URI: http://www.webbug.ru/2009/08/16/ulybaemsya-i-mashem-qip-smajly-dlya-wordpress/
Author: WebBug
Author URI: http://www.webbug.ru
*/

/*  
    Copyright 2009  Web Bug  (email : webbuger@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

*/


if( stristr($_SERVER['REQUEST_URI'], 'qips-js.php') ) {
	global $qips_conf;	
	include(dirname(__FILE__). '/qips-js.php');
	die(); exit;
}	

function qips_init() {	
	global $qips_conf, $smiles_array, $main_smiles_array;	
	// Directories
	$qips_conf['dir_srv_smiles'] 		= dirname(__FILE__). '/smiles';
	$qips_conf['dir_www_smiles'] 		= get_option('siteurl'). '/wp-content/plugins/qipsmiles/smiles';
	$qips_conf['dir_www_plugin'] 		= get_option('siteurl'). '/wp-content/plugins/qipsmiles';
	
	include(dirname(__FILE__). '/qips-functions.php');		
	
	if(@include (dirname(__FILE__).'/smiles/package.php')) {
		define('SMILES_INCLUDED', true);
	}
	else {
		define('SMILES_INCLUDED', false);
	}
	
	if(SMILES_INCLUDED) {
		add_filter('the_content', qips_replace_smiles); 
		add_filter('comment_text', qips_replace_smiles); 
	}
	elseif(!SMILES_INCLUDED) {
		header('Location: '. $_SERVER['REQUEST_URI']);			
	}
	//add_action('wp_footer', 'qips_javascript');
}

function qips_replace_smiles($text)	{
	global $qips_conf, $smiles_array, $main_smiles_array;
	
	foreach ($smiles_array as $title => $imgsrc) {
		$smiles_S[] = '/(\s|^)'.preg_quote($title, '/').'(\s|$)/';
		$smiles_masked = htmlspecialchars(trim($title), ENT_QUOTES);
		$smiles_R[] = ' <img src="'. $qips_conf['dir_www_smiles']. '/'. $imgsrc. '"  alt="'. $smiles_masked. '" title="'. $smiles_masked. '"/> ';
	}
	foreach ($main_smiles_array as $title => $imgsrc) {
		$smiles_S[] = '/(\s|^)'.preg_quote($title, '/').'(\s|$)/';
		$smiles_masked = htmlspecialchars(trim($title), ENT_QUOTES);
		$smiles_R[] = ' <img src="'. $qips_conf['dir_www_smiles']. '/'. $imgsrc. '"  alt="'. $smiles_masked. '" title="'. $smiles_masked. '"/> ';
	}

	$textarr = preg_split("/(<.*>)/U", $text, -1, PREG_SPLIT_DELIM_CAPTURE); 
	$stop = count($textarr);
	for ($i = 0; $i < $stop; $i++) {
		$content = $textarr[$i];
		if ((strlen($content) > 0) && ('<' != $content{0})) 
		{ 
			$content = preg_replace($smiles_S, $smiles_R, $content);
		}
		$output .= $content;
	}
	return $output;
}

function qipsmiles($lang = 'en') {
	global $qips_conf, $qips_options, $wpsmiliestrans, $smiles_array, $main_smiles_array;		
	
	$qips_conf['more'] 		= $lang == 'ru' ? 'Еще смайлы' : 'More smiles';
	
	echo '<div id="qips_smiles">'. "\r\n";	
	echo qips_build_smile_images($main_smiles_array);
	echo '<small><a style="text-decoration: none; border-bottom: 1px dashed; top: -5px; position: relative; margin-left: 3px;" href="javascript:void(0);" id="qips_button_smiles" title="'.$qips_conf['more'].'">'.$qips_conf['more'].'</a></small>';
	echo "</div>\r\n";	

	$qips_display = !SMILES_INCLUDED ? 'block' : 'none';
	echo '<div id="qips_smiles_toggle_wrapper" style="display: '. $qips_display. ';">'. "\r\n";
	
	if(!SMILES_INCLUDED) {
		echo '<p style="padding: 5px; background: yellow; color: red;"><strong>Error:</strong> Could not load <em><strong>package</strong></em>. Does it exist in <em><strong>'. str_replace('http://'. $_SERVER['HTTP_HOST'], '', $qips_conf['dir_www_smiles']). '/</strong></em> ?</p>';
	}
	else {		
		echo qips_build_smile_images($smiles_array);
	}
	echo "</div>\r\n";	
	qips_javascript();
}

add_action('init', 'qips_init');

?>