#include <16F676.h>
#device adc=10 
#fuses INTRC_IO,NOWDT,PUT,NOPROTECT,BROWNOUT,NOMCLR
#use delay (clock=4000000) // 4MHz clock

#rom  0x3ff={0x3444}

#byte PORTA = 0x05
#byte PORTC = 0x07
#byte TRISA = 0x85
#byte TRISC = 0x87

#define SPORTA PORTA
#define SPORTC PORTC

#define  TICKS_BETWEEN_INTERRUPTS      5000 //5000
#define  INTERRUPT_OVERHEAD            35
#define  TMR1RESET (0xFFFF-(TICKS_BETWEEN_INTERRUPTS-INTERRUPT_OVERHEAD))

const char SegCode[11] = {0x40,0x57,0x22,0x06,0x15,0x0C,0x08,0x56,0x00,0x04,0xFF};
	//                       0    1    2    3    4    5    6    7    8    9
const char Column[3]   = {0x02,0x01,0x04};
static char Segment[3] = {0x7f,0x7f,0x7f};	
static unsigned char ColCount=0x00;

void CPU_SETUP(void);
void Display(void);
void HTO7S(unsigned int32 Num);

byte i;
unsigned int32 result;

#INT_TIMER1
void Timer1(void)
{	
	set_timer1(TMR1RESET);
	Display();	
}	

void main()
{		
	unsigned char i;
	
	CPU_SETUP();
	
	while(true)
	{			
		result=0;
		for (i=0;i<20;i++)
		{
			set_adc_channel(3); 
			delay_ms(1); 
			result=result+read_adc();
		}
			//result = 0x3fe;									
	 	HTO7S(result/20);	
		delay_ms(200);		    
	}
	
}

void CPU_SETUP()
{
 	
   setup_comparator(NC_NC_NC_NC);	// not use comparator module
   setup_adc_ports( sAN3 | VSS_VDD); 
   setup_adc(ADC_CLOCK_DIV_64);
   TRISA=0b00011000;
   PORTA=0x27;
   TRISC=0b00000000;
   PORTC=0x37;
   
   
   setup_timer_1(T1_INTERNAL|T1_DIV_BY_1);
   set_timer1(TMR1RESET);
   enable_interrupts(GLOBAL);
   enable_interrupts(INT_TIMER1);   
}

//-------------------------------------
// Display routine
//-------------------------------------
void Display()
{
	PORTA = 0b00100111;	  // off all digits column and Segment G
	PORTC = 0b00111111;   // off segment a-f	
	delay_cycles(2);
	

	if (ColCount>=3) 
	ColCount=0;
    	
	SPORTC = Segment[ColCount];
	SPORTA = ((Segment[ColCount] & 0b01000000)>>1) | (Column[ColCount]^0x07);
	ColCount++;				
}	

//--------------------------------------
// Convet HEX 2 byte to 7-Segment code
//--------------------------------------
void HTO7S(unsigned int32 Num)
{

	unsigned int32 res;

	
	Segment[0]=SegCode[30*Num/10230];
	if (Segment[0]==0x40) 
	Segment[0]=0xFF;
	
	res = 30*Num%10230;
	Segment[1]=SegCode[10*res/10230];
	res=10*res%10230;
	Segment[2]=SegCode[10*res/10230];
}	
